/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.account.UserRepresentation;
import org.keycloak.representations.idm.AbstractUserRepresentation;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileUtil;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.StringUtil;

public final class DefaultUserProfile
implements UserProfile {
    private final UserProfileMetadata metadata;
    private final Function<Attributes, UserModel> userSupplier;
    private final Attributes attributes;
    private final KeycloakSession session;
    private boolean validated;
    private UserModel user;

    public DefaultUserProfile(UserProfileMetadata metadata, Attributes attributes, Function<Attributes, UserModel> userCreator, UserModel user, KeycloakSession session) {
        this.metadata = metadata;
        this.userSupplier = userCreator;
        this.attributes = attributes;
        this.user = user;
        this.session = session;
    }

    @Override
    public void validate() {
        ValidationException validationException = new ValidationException();
        for (String attributeName : this.attributes.nameSet()) {
            this.attributes.validate(attributeName, new Consumer[]{validationException});
        }
        if (validationException.hasError(new String[0])) {
            throw validationException;
        }
        this.validated = true;
    }

    @Override
    public UserModel create() throws ValidationException {
        if (this.user != null) {
            throw new RuntimeException("User already created");
        }
        if (!this.validated) {
            this.validate();
        }
        this.user = this.userSupplier.apply(this.attributes);
        return this.updateInternal(this.user, false, new AttributeChangeListener[0]);
    }

    @Override
    public void update(boolean removeAttributes, AttributeChangeListener ... changeListener) {
        if (!this.validated) {
            this.validate();
        }
        this.updateInternal(this.user, removeAttributes, changeListener);
    }

    private UserModel updateInternal(UserModel user, boolean removeAttributes, AttributeChangeListener ... changeListener) {
        if (user == null) {
            throw new RuntimeException("No user model provided for persisting changes");
        }
        try {
            List<String> currentValue;
            HashMap writable = new HashMap(this.attributes.getWritable());
            for (Map.Entry attribute : writable.entrySet()) {
                boolean ignoreEmptyValue;
                List updatedValue;
                String name = (String)attribute.getKey();
                currentValue = user.getAttributeStream(name).filter(Objects::nonNull).collect(Collectors.toList());
                if (CollectionUtil.collectionEquals(currentValue, updatedValue = ((List)attribute.getValue()).stream().filter(StringUtil::isNotBlank).collect(Collectors.toList()))) continue;
                boolean bl = ignoreEmptyValue = !removeAttributes && updatedValue.isEmpty();
                if (this.isCustomAttribute(name) && ignoreEmptyValue) continue;
                user.setAttribute(name, updatedValue);
                if ("email".equals(name) && this.metadata.getContext().isResetEmailVerified()) {
                    user.setEmailVerified(false);
                }
                for (AttributeChangeListener listener : changeListener) {
                    listener.onChange(name, user, currentValue);
                }
            }
            if (removeAttributes) {
                HashSet attrsToRemove = new HashSet(user.getAttributes().keySet());
                attrsToRemove.removeAll(this.attributes.nameSet());
                for (String name : attrsToRemove) {
                    if (this.attributes.isReadOnly(name)) continue;
                    currentValue = user.getAttributeStream(name).filter(Objects::nonNull).collect(Collectors.toList());
                    if (UserProfileUtil.isRootAttribute(name)) {
                        if ("firstName".equals(name)) {
                            user.setFirstName(null);
                        } else if ("lastName".equals(name)) {
                            user.setLastName(null);
                        } else if ("locale".equals(name)) {
                            user.removeAttribute(name);
                        }
                    } else {
                        user.removeAttribute(name);
                    }
                    for (AttributeChangeListener listener : changeListener) {
                        listener.onChange(name, user, currentValue);
                    }
                }
            }
        }
        catch (ModelException | ReadOnlyException e) {
            throw e;
        }
        catch (Exception cause) {
            throw new RuntimeException("Unexpected error when persisting user profile", cause);
        }
        return user;
    }

    private boolean isCustomAttribute(String name) {
        return !UserProfileUtil.isRootAttribute(name);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public <R extends AbstractUserRepresentation> R toRepresentation() {
        if (this.user == null) {
            throw new IllegalStateException("Can not create the representation because the user is not yet created");
        }
        R rep = this.createUserRepresentation();
        Map readable = this.attributes.getReadable();
        HashMap attributesRep = new HashMap(readable);
        for (String name : readable.keySet()) {
            String value;
            List values = attributesRep.getOrDefault(name, Collections.emptyList()).stream().filter(StringUtil::isNotBlank).collect(Collectors.toList());
            if (values.isEmpty()) {
                attributesRep.remove(name);
                continue;
            }
            if (!UserProfileUtil.isRootAttribute(name) || "locale".equals(name)) continue;
            boolean isUnmanagedAttribute = this.metadata.getAttribute(name).isEmpty();
            String string = value = isUnmanagedAttribute ? null : (String)values.stream().findFirst().orElse(null);
            if ("username".equals(name)) {
                rep.setUsername(value);
            } else if ("email".equals(name)) {
                rep.setEmail(value);
                rep.setEmailVerified(Boolean.valueOf(this.user.isEmailVerified()));
            } else if ("firstName".equals(name)) {
                rep.setFirstName(value);
            } else if ("lastName".equals(name)) {
                rep.setLastName(value);
            }
            attributesRep.remove(name);
        }
        rep.setId(this.user.getId());
        rep.setAttributes(attributesRep.isEmpty() ? null : attributesRep);
        rep.setUserProfileMetadata(UserProfileUtil.createUserProfileMetadata(this.session, this));
        return rep;
    }

    private <R extends AbstractUserRepresentation> R createUserRepresentation() {
        UserRepresentation rep;
        UserProfileContext context = this.metadata.getContext();
        if (context.isAdminContext()) {
            RealmModel realm = this.session.getContext().getRealm();
            rep = ModelToRepresentation.toRepresentation(this.session, realm, this.user);
        } else {
            rep = new UserRepresentation();
        }
        rep.setUsername(null);
        rep.setEmail(null);
        rep.setFirstName(null);
        rep.setLastName(null);
        return (R)rep;
    }
}

