/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class LengthFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final PatternRenderer stringPatternRenderer;
    private final PatternRenderer clobPatternRenderer;

    public LengthFunction(String functionName, String stringPattern, String clobPattern, TypeConfiguration typeConfiguration) {
        super(functionName, new ArgumentTypesValidator(StandardArgumentsValidators.exactly(1), FunctionParameterType.STRING_OR_CLOB), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.STRING));
        this.stringPatternRenderer = new PatternRenderer(stringPattern);
        this.clobPatternRenderer = new PatternRenderer(clobPattern);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression expression = (Expression)sqlAstArguments.get(0);
        JdbcType jdbcType = expression.getExpressionType().getSingleJdbcMapping().getJdbcType();
        switch (jdbcType.getDdlTypeCode()) {
            case 2005: 
            case 2011: {
                this.clobPatternRenderer.render(sqlAppender, sqlAstArguments, walker);
                break;
            }
            default: {
                this.stringPatternRenderer.render(sqlAppender, sqlAstArguments, walker);
            }
        }
    }
}

