/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.keycloak.validate.ValidationError;

public class ValidationResult {
    public static final ValidationResult OK = new ValidationResult(Collections.emptySet());
    private final Set<ValidationError> errors;

    public static ValidationResult of(ValidationError ... errors) {
        return new ValidationResult(Set.of(errors));
    }

    public static ValidationResult of(Set<ValidationError> errors) {
        return new ValidationResult(errors);
    }

    public ValidationResult(Set<ValidationError> errors) {
        this.errors = errors == null ? Collections.emptySet() : errors;
    }

    public void ifNotValidAccept(Consumer<ValidationResult> consumer) {
        if (!this.isValid()) {
            consumer.accept(this);
        }
    }

    public void forEachError(Consumer<ValidationError> consumer) {
        for (ValidationError error : this.getErrors()) {
            consumer.accept(error);
        }
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public Set<ValidationError> getErrors() {
        return this.errors;
    }

    public boolean hasErrorsForValidatorId(String id) {
        return this.getErrors().stream().anyMatch(e -> e.getValidatorId().equals(id));
    }

    public Set<ValidationError> getErrorsForValidatorId(String id) {
        return this.getErrors().stream().filter(e -> e.getValidatorId().equals(id)).collect(Collectors.toSet());
    }

    public boolean hasErrorsForInputHint(String inputHint) {
        return this.getErrors().stream().anyMatch(e -> e.getInputHint().equals(inputHint));
    }

    public Set<ValidationError> getErrorsForInputHint(String inputHint) {
        return this.getErrors().stream().filter(e -> e.getInputHint().equals(inputHint)).collect(Collectors.toSet());
    }
}

