/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.SetCHARCopyingBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class SetCHARBinder
extends Binder {
    byte[] paramVal;
    Binder theSetCHARCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)996;
        x.bytelen = 0;
    }

    SetCHARBinder(byte[] val) {
        SetCHARBinder.init(this);
        this.paramVal = val;
    }

    @Override
    Binder copyingBinder() {
        if (this.theSetCHARCopyingBinder == null) {
            this.theSetCHARCopyingBinder = new SetCHARCopyingBinder();
        }
        return this.theSetCHARCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            int len = value.length;
            bindIndicators[lenoffset] = len > 65532 ? -2 : (short)(len + 2);
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                bindDataLengths[bindDataIndex] = len;
                stmt.lastBoundDataLengths[bindPosition] = len;
                bindData.put(value, 0, len);
            } else {
                bindChars[charoffset] = (char)len;
                int cpos = charoffset + (len >> 1);
                if (len % 2 == 1) {
                    bindChars[cpos + 1] = (char)(value[--len] << 8);
                }
                while (len > 0) {
                    bindChars[cpos--] = (char)(value[len -= 2] << 8 | value[len + 1] & 0xFF);
                }
            }
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }

    @Override
    short updateInoutIndicatorValue(short inout) {
        return (short)(inout | 4);
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, this.paramVal, internalType, null, 0);
    }
}

