/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.Attributes;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileMetadata;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.utils.StringUtil;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class DefaultAttributes
extends HashMap<String, List<String>>
implements Attributes {
    private static final Logger logger = Logger.getLogger(DefaultAttributes.class);
    public static final String READ_ONLY_ATTRIBUTE_KEY = "kc.read.only";
    public static final String DEFAULT_MAX_LENGTH_ATTRIBUTES = "2048";
    protected final UserProfileContext context;
    protected final KeycloakSession session;
    private final Map<String, AttributeMetadata> metadataByAttribute;
    private final UPConfig upConfig;
    protected final UserModel user;
    private final Map<String, List<String>> unmanagedAttributes = new HashMap<String, List<String>>();

    public DefaultAttributes(UserProfileContext context, Map<String, ?> attributes, UserModel user, UserProfileMetadata profileMetadata, KeycloakSession session) {
        this.context = context;
        this.user = user;
        this.session = session;
        this.metadataByAttribute = this.configureMetadata(profileMetadata.getAttributes());
        this.upConfig = ((UserProfileProvider)session.getProvider(UserProfileProvider.class)).getConfiguration();
        this.putAll(Collections.unmodifiableMap(this.normalizeAttributes(attributes)));
    }

    public boolean isReadOnly(String name) {
        if (!this.isManagedAttribute(name)) {
            return !this.isAllowEditUnmanagedAttribute();
        }
        if ("username".equals(name) && this.isServiceAccountUser()) {
            return true;
        }
        if ("email".equals(name) && this.isServiceAccountUser()) {
            return false;
        }
        if (this.isReadOnlyFromMetadata(name) || this.isReadOnlyInternalAttribute(name)) {
            return true;
        }
        return this.getMetadata(name) == null;
    }

    private boolean isAllowEditUnmanagedAttribute() {
        UPConfig.UnmanagedAttributePolicy unmanagedAttributesPolicy = this.upConfig.getUnmanagedAttributePolicy();
        if (!this.isAllowUnmanagedAttribute()) {
            return false;
        }
        switch (unmanagedAttributesPolicy) {
            case ENABLED: {
                return true;
            }
            case ADMIN_EDIT: {
                return this.context.isAdminContext();
            }
        }
        return false;
    }

    protected boolean isReadOnlyFromMetadata(String attributeName) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(attributeName);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isReadOnly(this.createAttributeContext(attributeMetadata));
    }

    public boolean isRequired(String name) {
        AttributeMetadata attributeMetadata = this.metadataByAttribute.get(name);
        if (attributeMetadata == null) {
            return false;
        }
        return attributeMetadata.isRequired(this.createAttributeContext(attributeMetadata));
    }

    public boolean validate(String name, Consumer<ValidationError> ... listeners) {
        AbstractMap.SimpleImmutableEntry<String, List<String>> attribute = this.createAttribute(name);
        ArrayList<AttributeMetadata> metadatas = new ArrayList<AttributeMetadata>();
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(attribute.getKey())).map(Collections::singletonList).orElse(Collections.emptyList()));
        metadatas.addAll(Optional.ofNullable(this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY)).map(Collections::singletonList).orElse(Collections.emptyList()));
        this.addDefaultValidators(name, metadatas);
        Boolean result = null;
        for (AttributeMetadata metadata : metadatas) {
            AttributeContext attributeContext = this.createAttributeContext(attribute, metadata);
            for (AttributeValidatorMetadata validator : metadata.getValidators()) {
                List newValue;
                List value;
                ValidationContext vc = validator.validate(attributeContext);
                if (vc.isValid()) continue;
                if (this.user != null && metadata.isReadOnly(attributeContext) && CollectionUtil.collectionEquals(value = this.user.getAttributeStream(name).filter(StringUtil::isNotBlank).collect(Collectors.toList()), newValue = ((List)attribute.getValue()).stream().filter(StringUtil::isNotBlank).collect(Collectors.toList()))) {
                    logger.debugf("User '%s' attribute '%s' has previous validation errors %s but is read-only in context %s.", new Object[]{this.user.getUsername(), name, vc.getErrors(), attributeContext.getContext()});
                    continue;
                }
                if (result == null) {
                    result = false;
                }
                if (listeners == null) continue;
                for (ValidationError error : vc.getErrors()) {
                    for (Consumer<ValidationError> consumer : listeners) {
                        consumer.accept(error);
                    }
                }
            }
        }
        return result == null;
    }

    protected void addDefaultValidators(String name, List<AttributeMetadata> metadatas) {
        this.addLengthValidatorIfNotSet(name, metadatas);
    }

    private void addLengthValidatorIfNotSet(String name, List<AttributeMetadata> metadatas) {
        for (AttributeMetadata metadata : metadatas) {
            for (AttributeValidatorMetadata validator : metadata.getValidators()) {
                if (!validator.getValidatorId().equals("length")) continue;
                return;
            }
        }
        AttributeMetadata am = new AttributeMetadata(name, -1);
        HashMap<String, String> vc = new HashMap<String, String>();
        vc.put("min", "0");
        vc.put("max", DEFAULT_MAX_LENGTH_ATTRIBUTES);
        am.addValidators(Collections.singletonList(new AttributeValidatorMetadata("length", new ValidatorConfig(vc))));
        metadatas.add(am);
    }

    public List<String> get(String name) {
        return this.getOrDefault(name, EMPTY_VALUE);
    }

    public boolean contains(String name) {
        return this.containsKey(name);
    }

    public Set<String> nameSet() {
        return this.keySet();
    }

    public Map<String, List<String>> getWritable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this);
        for (String name : this.nameSet()) {
            AttributeMetadata metadata = this.getMetadata(name);
            RealmModel realm = this.session.getContext().getRealm();
            if ("username".equals(name) && realm.isRegistrationEmailAsUsername() || !this.isManagedAttribute(name) || metadata != null && metadata.canEdit(this.createAttributeContext(metadata))) continue;
            attributes.remove(name);
        }
        return attributes;
    }

    public AttributeMetadata getMetadata(String name) {
        if (this.unmanagedAttributes.containsKey(name)) {
            return this.createUnmanagedAttributeMetadata(name);
        }
        return Optional.ofNullable(this.metadataByAttribute.get(name)).map(AttributeMetadata::clone).orElse(null);
    }

    public Map<String, List<String>> getReadable() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>(this);
        for (String name : this.nameSet()) {
            AttributeMetadata metadata = this.getMetadata(name);
            if (metadata == null) {
                attributes.remove(name);
                continue;
            }
            AttributeContext attributeContext = this.createAttributeContext(metadata);
            if (metadata.canView(attributeContext) && metadata.isSelected(attributeContext)) continue;
            attributes.remove(name);
        }
        return attributes;
    }

    public Map<String, List<String>> toMap() {
        return Collections.unmodifiableMap(this);
    }

    protected boolean isServiceAccountUser() {
        return this.user != null && this.user.getServiceAccountClientLink() != null;
    }

    private AttributeContext createAttributeContext(Map.Entry<String, List<String>> attribute, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, attribute, this.user, metadata, (Attributes)this);
    }

    private AttributeContext createAttributeContext(String attributeName, AttributeMetadata metadata) {
        return new AttributeContext(this.context, this.session, this.createAttribute(attributeName), this.user, metadata, (Attributes)this);
    }

    protected AttributeContext createAttributeContext(AttributeMetadata metadata) {
        return this.createAttributeContext(this.createAttribute(metadata.getName()), metadata);
    }

    private Map<String, AttributeMetadata> configureMetadata(List<AttributeMetadata> attributes) {
        HashMap<String, AttributeMetadata> metadatas = new HashMap<String, AttributeMetadata>();
        for (AttributeMetadata metadata : attributes) {
            if (!metadata.isSelected(this.createAttributeContext(metadata))) continue;
            metadatas.put(metadata.getName(), metadata);
        }
        return metadatas;
    }

    private AbstractMap.SimpleImmutableEntry<String, List<String>> createAttribute(final String name) {
        return new AbstractMap.SimpleImmutableEntry<String, List<String>>(name, null){

            @Override
            public List<String> getValue() {
                List<String> values = DefaultAttributes.this.get(name);
                if (values == null) {
                    return Attributes.EMPTY_VALUE;
                }
                return values;
            }
        };
    }

    private Map<String, List<String>> normalizeAttributes(Map<String, ?> attributes) {
        List<String> email;
        List username;
        HashMap<String, List<String>> newAttributes = new HashMap<String, List<String>>();
        RealmModel realm = this.session.getContext().getRealm();
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String normalizedName;
                String name = (String)entry.getKey();
                if (!this.isSupportedAttribute(name)) {
                    if (this.isManagedAttribute(name) || !this.isAllowUnmanagedAttribute()) continue;
                    normalizedName = DefaultAttributes.normalizeAttributeName(name);
                    this.unmanagedAttributes.put(normalizedName, this.normalizeAttributeValues(normalizedName, entry.getValue()));
                    continue;
                }
                normalizedName = DefaultAttributes.normalizeAttributeName(name);
                List<String> values = this.normalizeAttributeValues(normalizedName, entry.getValue());
                newAttributes.put(normalizedName, Collections.unmodifiableList(values));
            }
        }
        for (String string : this.metadataByAttribute.keySet()) {
            if (!this.isSupportedAttribute(string) || newAttributes.containsKey(string)) continue;
            List<String> values = EMPTY_VALUE;
            AttributeMetadata metadata = this.metadataByAttribute.get(string);
            if (this.user != null && this.isIncludeAttributeIfNotProvided(metadata)) {
                values = this.normalizeAttributeValues(string, this.user.getAttributes().getOrDefault(string, EMPTY_VALUE));
            }
            newAttributes.put(string, values);
        }
        if (this.user != null && (username = newAttributes.getOrDefault("username", Collections.emptyList())).isEmpty() && this.isReadOnly("username")) {
            this.setUserName(newAttributes, Collections.singletonList(this.user.getUsername()));
        }
        if (!(email = newAttributes.getOrDefault("email", Collections.emptyList())).isEmpty() && realm.isRegistrationEmailAsUsername()) {
            this.setUserName(newAttributes, email);
            if (this.user != null && this.isReadOnly("email")) {
                newAttributes.put("email", Collections.singletonList(this.user.getEmail()));
                this.setUserName(newAttributes, Collections.singletonList(this.user.getEmail()));
            }
        }
        if (this.isAllowUnmanagedAttribute()) {
            newAttributes.putAll(this.unmanagedAttributes);
        }
        return newAttributes;
    }

    private static String normalizeAttributeName(String name) {
        if (name.startsWith("user.attributes.")) {
            return name.substring("user.attributes.".length());
        }
        return name;
    }

    protected List<String> normalizeAttributeValues(String name, Object value) {
        List<String> values = value instanceof String ? Collections.singletonList((String)value) : (List<String>)value;
        Stream<String> valuesStream = Optional.ofNullable(values).orElse(EMPTY_VALUE).stream().filter(Objects::nonNull);
        if ("username".equals(name) || "email".equals(name)) {
            valuesStream = valuesStream.map(KeycloakModelUtils::toLowerCaseSafe);
        }
        return valuesStream.collect(Collectors.toList());
    }

    private boolean isAllowUnmanagedAttribute() {
        UPConfig.UnmanagedAttributePolicy unmanagedAttributePolicy = this.upConfig.getUnmanagedAttributePolicy();
        if (unmanagedAttributePolicy == null) {
            return false;
        }
        switch (unmanagedAttributePolicy) {
            case ADMIN_EDIT: 
            case ADMIN_VIEW: {
                return this.context.isAdminContext();
            }
        }
        return UPConfig.UnmanagedAttributePolicy.ENABLED.equals((Object)unmanagedAttributePolicy);
    }

    private void setUserName(Map<String, List<String>> newAttributes, List<String> lowerCaseEmailList) {
        if (this.isServiceAccountUser()) {
            return;
        }
        newAttributes.put("username", lowerCaseEmailList);
    }

    protected boolean isIncludeAttributeIfNotProvided(AttributeMetadata metadata) {
        return !metadata.canEdit(this.createAttributeContext(metadata));
    }

    protected boolean isSupportedAttribute(String name) {
        if (READ_ONLY_ATTRIBUTE_KEY.equals(name)) {
            return false;
        }
        if (this.isManagedAttribute(name)) {
            return true;
        }
        if (this.isServiceAccountUser()) {
            return true;
        }
        return this.isReadOnlyInternalAttribute(name);
    }

    private boolean isManagedAttribute(String name) {
        return this.metadataByAttribute.containsKey(DefaultAttributes.normalizeAttributeName(name));
    }

    protected boolean isReadOnlyInternalAttribute(String attributeName) {
        AttributeMetadata readonlyMetadata = this.metadataByAttribute.get(READ_ONLY_ATTRIBUTE_KEY);
        if (readonlyMetadata == null) {
            return false;
        }
        AttributeContext attributeContext = this.createAttributeContext(attributeName, readonlyMetadata);
        for (AttributeValidatorMetadata validator : readonlyMetadata.getValidators()) {
            ValidationContext vc = validator.validate(attributeContext);
            if (vc.isValid()) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<String>> getUnmanagedAttributes() {
        return this.unmanagedAttributes;
    }

    private AttributeMetadata createUnmanagedAttributeMetadata(String name) {
        return new AttributeMetadata(name, Integer.MAX_VALUE){
            final UPConfig.UnmanagedAttributePolicy unmanagedAttributePolicy;
            {
                this.unmanagedAttributePolicy = DefaultAttributes.this.upConfig.getUnmanagedAttributePolicy();
            }

            public boolean canView(AttributeContext context) {
                return this.canEdit(context) || UPConfig.UnmanagedAttributePolicy.ADMIN_VIEW.equals((Object)this.unmanagedAttributePolicy) && context.getContext().isAdminContext();
            }

            public boolean canEdit(AttributeContext context) {
                return UPConfig.UnmanagedAttributePolicy.ENABLED.equals((Object)this.unmanagedAttributePolicy) || UPConfig.UnmanagedAttributePolicy.ADMIN_EDIT.equals((Object)this.unmanagedAttributePolicy) && context.getContext().isAdminContext();
            }
        };
    }
}

