/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.AccountRoles;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.BrowserSecurityHeaders;
import org.keycloak.models.ClientModel;
import org.keycloak.models.Constants;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.models.utils.DefaultClientScopes;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.models.utils.DefaultRequiredActions;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.clientregistration.policy.DefaultClientRegistrationPolicies;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.storage.StoreMigrateRepresentationEvent;
import org.keycloak.storage.StoreSyncEvent;
import org.keycloak.utils.ReservedCharValidator;
import org.keycloak.utils.StringUtil;

public class RealmManager {
    protected KeycloakSession session;
    protected RealmProvider model;

    public RealmManager(KeycloakSession session) {
        this.session = session;
        this.model = session.realms();
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public RealmModel getKeycloakAdminstrationRealm() {
        return this.getRealmByName(Config.getAdminRealm());
    }

    public static boolean isAdministrationRealm(RealmModel realm) {
        return realm.getName().equals(Config.getAdminRealm());
    }

    public RealmModel getRealm(String id) {
        return this.model.getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.model.getRealmByName(name);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(null, name);
    }

    public RealmModel createRealm(String id, String name) {
        if (id == null || id.trim().isEmpty()) {
            id = KeycloakModelUtils.generateId();
        } else {
            ReservedCharValidator.validate((String)id);
        }
        ReservedCharValidator.validate((String)name);
        RealmModel realm = this.model.createRealm(id, name);
        realm.setName(name);
        this.setupRealmDefaults(realm);
        KeycloakModelUtils.setupDefaultRole((RealmModel)realm, (String)("default-roles-" + name.toLowerCase()));
        this.setupMasterAdminManagement(realm);
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupBrokerService(realm);
        this.setupAdminConsole(realm);
        this.setupAdminConsoleLocaleMapper(realm);
        this.setupAdminCli(realm);
        this.setupImpersonationService(realm);
        this.setupAuthenticationFlows(realm);
        this.setupRequiredActions(realm);
        this.setupOfflineTokens(realm, null);
        this.createDefaultClientScopes(realm);
        this.setupAuthorizationServices(realm);
        this.setupClientRegistrations(realm);
        this.session.clientPolicy().setupClientPoliciesOnCreatedRealm(realm);
        this.fireRealmPostCreate(realm);
        return realm;
    }

    protected void setupAuthenticationFlows(RealmModel realm) {
        if (realm.getAuthenticationFlowsStream().count() == 0L) {
            DefaultAuthenticationFlows.addFlows((RealmModel)realm);
        }
    }

    protected void setupRequiredActions(RealmModel realm) {
        if (realm.getRequiredActionProvidersStream().count() == 0L) {
            DefaultRequiredActions.addActions((RealmModel)realm);
        }
    }

    private void setupOfflineTokens(RealmModel realm, RealmRepresentation realmRep) {
        RoleModel offlineRole = KeycloakModelUtils.setupOfflineRole((RealmModel)realm);
        if (realmRep != null && this.hasRealmRole(realmRep, "offline_access")) {
            List realmRoles = realmRep.getRoles().getRealm();
            for (RoleRepresentation role : realmRoles) {
                if (!"offline_access".equals(role.getName())) continue;
                realmRoles.remove(role);
                break;
            }
        }
        if (realmRep == null || !this.hasClientScope(realmRep, "offline_access")) {
            DefaultClientScopes.createOfflineAccessClientScope((RealmModel)realm, (RoleModel)offlineRole);
        }
    }

    protected void createDefaultClientScopes(RealmModel realm) {
        DefaultClientScopes.createDefaultClientScopes((KeycloakSession)this.session, (RealmModel)realm, (boolean)true);
    }

    protected void setupAdminConsole(RealmModel realm) {
        ClientModel adminConsole = realm.getClientByClientId("security-admin-console");
        if (adminConsole == null) {
            adminConsole = KeycloakModelUtils.createPublicClient((RealmModel)realm, (String)"security-admin-console");
        }
        adminConsole.setName("${client_security-admin-console}");
        adminConsole.setRootUrl("${authAdminUrl}");
        String baseUrl = "/admin/" + realm.getName() + "/console/";
        adminConsole.setBaseUrl(baseUrl);
        adminConsole.addRedirectUri(baseUrl + "*");
        adminConsole.setAttribute("post.logout.redirect.uris", "+");
        adminConsole.setWebOrigins(Collections.singleton("+"));
        adminConsole.setEnabled(true);
        adminConsole.setAlwaysDisplayInConsole(false);
        adminConsole.setPublicClient(true);
        adminConsole.setFullScopeAllowed(false);
        adminConsole.setProtocol("openid-connect");
        adminConsole.setAttribute("pkce.code.challenge.method", "S256");
    }

    protected void setupAdminConsoleLocaleMapper(RealmModel realm) {
        ClientModel adminConsole = this.session.clients().getClientByClientId(realm, "security-admin-console");
        ProtocolMapperModel localeMapper = adminConsole.getProtocolMapperByName("openid-connect", "locale");
        if (localeMapper == null && (localeMapper = ProtocolMapperUtils.findLocaleMapper(this.session)) != null) {
            adminConsole.addProtocolMapper(localeMapper);
        }
    }

    public void setupAdminCli(RealmModel realm) {
        ClientModel adminCli = realm.getClientByClientId("admin-cli");
        if (adminCli == null) {
            adminCli = KeycloakModelUtils.createPublicClient((RealmModel)realm, (String)"admin-cli");
            adminCli.setName("${client_admin-cli}");
            adminCli.setEnabled(true);
            adminCli.setAlwaysDisplayInConsole(false);
            adminCli.setFullScopeAllowed(false);
            adminCli.setStandardFlowEnabled(false);
            adminCli.setDirectAccessGrantsEnabled(true);
            adminCli.setProtocol("openid-connect");
        }
    }

    public void addQueryCompositeRoles(ClientModel realmAccess) {
        RoleModel queryClients = realmAccess.getRole(AdminRoles.QUERY_CLIENTS);
        RoleModel queryUsers = realmAccess.getRole(AdminRoles.QUERY_USERS);
        RoleModel queryGroups = realmAccess.getRole(AdminRoles.QUERY_GROUPS);
        RoleModel viewClients = realmAccess.getRole(AdminRoles.VIEW_CLIENTS);
        viewClients.addCompositeRole(queryClients);
        RoleModel viewUsers = realmAccess.getRole(AdminRoles.VIEW_USERS);
        viewUsers.addCompositeRole(queryUsers);
        viewUsers.addCompositeRole(queryGroups);
    }

    public String getRealmAdminClientId(RealmModel realm) {
        return "realm-management";
    }

    public String getRealmAdminClientId(RealmRepresentation realm) {
        return "realm-management";
    }

    protected void setupRealmDefaults(RealmModel realm) {
        realm.setBrowserSecurityHeaders(BrowserSecurityHeaders.realmDefaultHeaders);
        realm.setBruteForceProtected(false);
        realm.setPermanentLockout(false);
        realm.setMaxTemporaryLockouts(0);
        realm.setMaxFailureWaitSeconds(900);
        realm.setMinimumQuickLoginWaitSeconds(60);
        realm.setWaitIncrementSeconds(60);
        realm.setQuickLoginCheckMilliSeconds(1000L);
        realm.setMaxDeltaTimeSeconds(43200);
        realm.setFailureFactor(30);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setOTPPolicy(OTPPolicy.DEFAULT_POLICY);
        realm.setLoginWithEmailAllowed(true);
        realm.setEventsListeners(Collections.singleton("jboss-logging"));
    }

    public boolean removeRealm(RealmModel realm) {
        ClientModel masterAdminClient = realm.getMasterAdminClient();
        boolean removed = this.model.removeRealm(realm.getId());
        if (removed) {
            AuthenticationSessionProvider authSessions;
            UserSessionProvider sessions;
            if (masterAdminClient != null) {
                this.session.clients().removeClient(this.getKeycloakAdminstrationRealm(), masterAdminClient.getId());
            }
            if ((sessions = this.session.sessions()) != null) {
                sessions.onRealmRemoved(realm);
            }
            if ((authSessions = this.session.authenticationSessions()) != null) {
                authSessions.onRealmRemoved(realm);
            }
            StoreSyncEvent.fire((KeycloakSession)this.session, (RealmModel)realm, (boolean)true);
        }
        return removed;
    }

    public void updateRealmEventsConfig(RealmEventsConfigRepresentation rep, RealmModel realm) {
        realm.setEventsEnabled(rep.isEventsEnabled());
        realm.setEventsExpiration(rep.getEventsExpiration() != null ? rep.getEventsExpiration() : 0L);
        if (rep.getEventsListeners() != null) {
            realm.setEventsListeners(new HashSet(rep.getEventsListeners()));
        }
        if (rep.getEnabledEventTypes() != null) {
            realm.setEnabledEventTypes(new HashSet(rep.getEnabledEventTypes()));
        }
        if (rep.isAdminEventsEnabled() != null) {
            realm.setAdminEventsEnabled(rep.isAdminEventsEnabled().booleanValue());
        }
        if (rep.isAdminEventsDetailsEnabled() != null) {
            realm.setAdminEventsDetailsEnabled(rep.isAdminEventsDetailsEnabled().booleanValue());
        }
    }

    public void setupMasterAdminManagement(RealmModel realm) {
        String adminRealmName = Config.getAdminRealm();
        RealmModel adminRealm = this.model.getRealmByName(adminRealmName);
        ClientModel masterApp = adminRealm.getClientByClientId(KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)realm.getName()));
        if (masterApp == null) {
            this.createMasterAdminManagement(realm);
            return;
        }
        realm.setMasterAdminClient(masterApp);
    }

    private void createMasterAdminManagement(RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.addRole(AdminRoles.ADMIN);
            RoleModel createRealmRole = realm.addRole(AdminRoles.CREATE_REALM);
            adminRole.addCompositeRole(createRealmRole);
            createRealmRole.setDescription("${role_" + AdminRoles.CREATE_REALM + "}");
        } else {
            adminRealm = this.model.getRealmByName(Config.getAdminRealm());
            adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        }
        adminRole.setDescription("${role_" + AdminRoles.ADMIN + "}");
        ClientModel realmAdminApp = KeycloakModelUtils.createManagementClient((RealmModel)adminRealm, (String)KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)realm.getName()));
        realmAdminApp.setName(realm.getName() + " Realm");
        realm.setMasterAdminClient(realmAdminApp);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            role.setDescription("${role_" + r + "}");
            adminRole.addCompositeRole(role);
        }
        this.addQueryCompositeRoles(realmAdminApp);
    }

    private void checkMasterAdminManagementRoles(RealmModel realm) {
        RealmModel adminRealm = this.model.getRealmByName(Config.getAdminRealm());
        RoleModel adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        ClientModel masterAdminClient = realm.getMasterAdminClient();
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel found = masterAdminClient.getRole(r);
            if (found != null) continue;
            this.addAndSetAdminRole(r, masterAdminClient, adminRole);
        }
        this.addQueryCompositeRoles(masterAdminClient);
    }

    private void setupRealmAdminManagement(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminClientId = this.getRealmAdminClientId(realm);
        ClientModel realmAdminClient = realm.getClientByClientId(realmAdminClientId);
        if (realmAdminClient == null) {
            realmAdminClient = KeycloakModelUtils.createManagementClient((RealmModel)realm, (String)realmAdminClientId);
            realmAdminClient.setName("${client_" + realmAdminClientId + "}");
        }
        RoleModel adminRole = realmAdminClient.addRole(AdminRoles.REALM_ADMIN);
        adminRole.setDescription("${role_" + AdminRoles.REALM_ADMIN + "}");
        realmAdminClient.setBearerOnly(true);
        realmAdminClient.setFullScopeAllowed(false);
        realmAdminClient.setProtocol("openid-connect");
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            this.addAndSetAdminRole(r, realmAdminClient, adminRole);
        }
        this.addQueryCompositeRoles(realmAdminClient);
    }

    private void addAndSetAdminRole(String roleName, ClientModel parentClient, RoleModel parentRole) {
        RoleModel role = parentClient.addRole(roleName);
        role.setDescription("${role_" + roleName + "}");
        parentRole.addCompositeRole(role);
    }

    private void checkRealmAdminManagementRoles(RealmModel realm) {
        if (realm.getName().equals(Config.getAdminRealm())) {
            return;
        }
        String realmAdminClientId = this.getRealmAdminClientId(realm);
        ClientModel realmAdminClient = realm.getClientByClientId(realmAdminClientId);
        RoleModel adminRole = realmAdminClient.getRole(AdminRoles.REALM_ADMIN);
        if (adminRole == null) {
            adminRole = realmAdminClient.addRole(AdminRoles.REALM_ADMIN);
            adminRole.setDescription("${role_" + AdminRoles.REALM_ADMIN + "}");
        }
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel found = realmAdminClient.getRole(r);
            if (found != null) continue;
            this.addAndSetAdminRole(r, realmAdminClient, adminRole);
        }
        this.addQueryCompositeRoles(realmAdminClient);
    }

    private void setupAccountManagement(RealmModel realm) {
        ClientModel accountClient = realm.getClientByClientId("account");
        if (accountClient == null) {
            accountClient = KeycloakModelUtils.createPublicClient((RealmModel)realm, (String)"account");
            accountClient.setName("${client_account}");
            accountClient.setEnabled(true);
            accountClient.setAlwaysDisplayInConsole(false);
            accountClient.setFullScopeAllowed(false);
            accountClient.setRootUrl("${authBaseUrl}");
            String baseUrl = "/realms/" + realm.getName() + "/account/";
            accountClient.setBaseUrl(baseUrl);
            accountClient.addRedirectUri(baseUrl + "*");
            accountClient.setAttribute("post.logout.redirect.uris", "+");
            accountClient.setProtocol("openid-connect");
            for (String role : AccountRoles.DEFAULT) {
                RoleModel roleModel = accountClient.addRole(role);
                roleModel.setDescription("${role_" + role + "}");
                realm.addToDefaultRoles(roleModel);
            }
            RoleModel manageAccountLinks = accountClient.addRole("manage-account-links");
            manageAccountLinks.setDescription("${role_manage-account-links}");
            RoleModel manageAccount = accountClient.getRole("manage-account");
            manageAccount.addCompositeRole(manageAccountLinks);
            RoleModel viewAppRole = accountClient.addRole("view-applications");
            viewAppRole.setDescription("${role_view-applications}");
            RoleModel viewConsentRole = accountClient.addRole("view-consent");
            viewConsentRole.setDescription("${role_view-consent}");
            RoleModel manageConsentRole = accountClient.addRole("manage-consent");
            manageConsentRole.setDescription("${role_manage-consent}");
            manageConsentRole.addCompositeRole(viewConsentRole);
            RoleModel viewGroups = accountClient.addRole("view-groups");
            viewGroups.setDescription("${role_view-groups}");
            KeycloakModelUtils.setupDeleteAccount((ClientModel)accountClient);
            ClientModel accountConsoleClient = realm.getClientByClientId("account-console");
            if (accountConsoleClient == null) {
                accountConsoleClient = KeycloakModelUtils.createPublicClient((RealmModel)realm, (String)"account-console");
                accountConsoleClient.setName("${client_account-console}");
                accountConsoleClient.setEnabled(true);
                accountConsoleClient.setAlwaysDisplayInConsole(false);
                accountConsoleClient.setFullScopeAllowed(false);
                accountConsoleClient.setDirectAccessGrantsEnabled(false);
                accountConsoleClient.setRootUrl("${authBaseUrl}");
                accountConsoleClient.setBaseUrl(baseUrl);
                accountConsoleClient.addRedirectUri(baseUrl + "*");
                accountConsoleClient.setAttribute("post.logout.redirect.uris", "+");
                accountConsoleClient.setProtocol("openid-connect");
                accountConsoleClient.addScopeMapping(accountClient.getRole("manage-account"));
                accountConsoleClient.addScopeMapping(accountClient.getRole("view-groups"));
                ProtocolMapperModel audienceMapper = new ProtocolMapperModel();
                audienceMapper.setName("audience resolve");
                audienceMapper.setProtocol("openid-connect");
                audienceMapper.setProtocolMapper("oidc-audience-resolve-mapper");
                accountConsoleClient.addProtocolMapper(audienceMapper);
                accountConsoleClient.setAttribute("pkce.code.challenge.method", "S256");
            }
        }
    }

    public void setupImpersonationService(RealmModel realm) {
        ImpersonationConstants.setupImpersonationService((KeycloakSession)this.session, (RealmModel)realm);
    }

    public void setupBrokerService(RealmModel realm) {
        ClientModel client = realm.getClientByClientId("broker");
        if (client == null) {
            client = KeycloakModelUtils.createManagementClient((RealmModel)realm, (String)"broker");
            client.setEnabled(true);
            client.setAlwaysDisplayInConsole(false);
            client.setName("${client_broker}");
            client.setFullScopeAllowed(false);
            client.setProtocol("openid-connect");
            for (String role : Constants.BROKER_SERVICE_ROLES) {
                RoleModel roleModel = client.addRole(role);
                roleModel.setDescription("${role_" + role.toLowerCase().replaceAll("_", "-") + "}");
            }
        }
    }

    public RealmModel importRealm(RealmRepresentation rep) {
        return this.importRealm(rep, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmModel importRealm(RealmRepresentation rep, boolean skipUserDependent) {
        String id = rep.getId();
        if (id == null || id.trim().isEmpty()) {
            id = KeycloakModelUtils.generateId();
        } else {
            ReservedCharValidator.validate((String)id);
        }
        if (StringUtil.isBlank((String)rep.getRealm())) {
            throw new ModelException("Realm name cannot be empty");
        }
        final RealmModel realm = this.model.createRealm(id, rep.getRealm());
        RealmModel currentRealm = this.session.getContext().getRealm();
        try {
            boolean postponeImpersonationSetup;
            this.session.getContext().setRealm(realm);
            ReservedCharValidator.validate((String)rep.getRealm());
            realm.setName(rep.getRealm());
            this.setupRealmDefaults(realm);
            if (rep.getDefaultRole() == null) {
                KeycloakModelUtils.setupDefaultRole((RealmModel)realm, (String)this.determineDefaultRoleName(rep));
            } else {
                realm.setDefaultRole(RepresentationToModel.createRole((RealmModel)realm, (RoleRepresentation)rep.getDefaultRole()));
            }
            boolean postponeMasterClientSetup = this.postponeMasterClientSetup(rep);
            if (!postponeMasterClientSetup) {
                this.setupMasterAdminManagement(realm);
            }
            if (!this.hasRealmAdminManagementClient(rep)) {
                this.setupRealmAdminManagement(realm);
            }
            if (!this.hasAccountManagementClient(rep)) {
                this.setupAccountManagement(realm);
            }
            if (!(postponeImpersonationSetup = this.hasRealmAdminManagementClient(rep))) {
                this.setupImpersonationService(realm);
            }
            if (!this.hasBrokerClient(rep)) {
                this.setupBrokerService(realm);
            }
            if (!this.hasAdminConsoleClient(rep)) {
                this.setupAdminConsole(realm);
            }
            boolean postponeAdminCliSetup = false;
            if (!this.hasAdminCliClient(rep) && !(postponeAdminCliSetup = this.hasRealmAdminManagementClient(rep))) {
                this.setupAdminCli(realm);
            }
            if (!this.hasRealmRole(rep, "offline_access") || !this.hasClientScope(rep, "offline_access")) {
                this.setupOfflineTokens(realm, rep);
            }
            if (rep.getClientScopes() == null) {
                this.createDefaultClientScopes(realm);
            }
            RepresentationToModel.importRealm((KeycloakSession)this.session, (RealmRepresentation)rep, (RealmModel)realm, (boolean)skipUserDependent);
            this.setupClientServiceAccountsAndAuthorizationOnImport(rep, skipUserDependent);
            this.setupAdminConsoleLocaleMapper(realm);
            if (postponeMasterClientSetup) {
                this.setupMasterAdminManagement(realm);
            }
            if (rep.getRoles() != null || this.hasRealmAdminManagementClient(rep)) {
                this.checkMasterAdminManagementRoles(realm);
                this.checkRealmAdminManagementRoles(realm);
            }
            if (postponeImpersonationSetup) {
                this.setupImpersonationService(realm);
            }
            if (postponeAdminCliSetup) {
                this.setupAdminCli(realm);
            }
            this.setupAuthenticationFlows(realm);
            this.setupRequiredActions(realm);
            if (!this.hasRealmRole(rep, "delete-account")) {
                KeycloakModelUtils.setupDeleteAccount((ClientModel)realm.getClientByClientId("account"));
            }
            this.session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AbstractKeycloakTransaction(){

                protected void commitImpl() {
                    StoreSyncEvent.fire((KeycloakSession)RealmManager.this.session, (RealmModel)realm, (boolean)false);
                }

                protected void rollbackImpl() {
                }
            });
            this.setupAuthorizationServices(realm);
            this.setupClientRegistrations(realm);
            if (rep.getKeycloakVersion() != null) {
                StoreMigrateRepresentationEvent.fire((KeycloakSession)this.session, (RealmModel)realm, (RealmRepresentation)rep, (boolean)skipUserDependent);
            }
            this.session.clientPolicy().updateRealmModelFromRepresentation(realm, rep);
            this.fireRealmPostCreate(realm);
        }
        finally {
            this.session.getContext().setRealm(currentRealm);
        }
        return realm;
    }

    private String determineDefaultRoleName(RealmRepresentation rep) {
        String defaultRoleName = "default-roles-" + rep.getRealm().toLowerCase();
        if (!this.hasRealmRole(rep, defaultRoleName)) {
            return defaultRoleName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            defaultRoleName = "default-roles-" + rep.getRealm().toLowerCase() + "-" + i;
            if (this.hasRealmRole(rep, defaultRoleName)) continue;
            return defaultRoleName;
        }
        return null;
    }

    private boolean postponeMasterClientSetup(RealmRepresentation rep) {
        if (!Config.getAdminRealm().equals(rep.getRealm())) {
            return false;
        }
        return this.hasRealmAdminManagementClient(rep);
    }

    private boolean hasRealmAdminManagementClient(RealmRepresentation rep) {
        String realmAdminClientId = Config.getAdminRealm().equals(rep.getRealm()) ? KeycloakModelUtils.getMasterRealmAdminApplicationClientId((String)rep.getRealm()) : this.getRealmAdminClientId(rep);
        return this.hasClient(rep, realmAdminClientId);
    }

    private boolean hasAccountManagementClient(RealmRepresentation rep) {
        return this.hasClient(rep, "account");
    }

    private boolean hasBrokerClient(RealmRepresentation rep) {
        return this.hasClient(rep, "broker");
    }

    private boolean hasAdminConsoleClient(RealmRepresentation rep) {
        return this.hasClient(rep, "security-admin-console");
    }

    private boolean hasAdminCliClient(RealmRepresentation rep) {
        return this.hasClient(rep, "admin-cli");
    }

    private boolean hasClient(RealmRepresentation rep, String clientId) {
        if (rep.getClients() != null) {
            for (ClientRepresentation clientRep : rep.getClients()) {
                if (clientRep.getClientId() == null || !clientRep.getClientId().equals(clientId)) continue;
                return true;
            }
        }
        if (rep.getApplications() != null) {
            for (ClientRepresentation clientRep : rep.getApplications()) {
                if (!clientRep.getName().equals(clientId)) continue;
                return true;
            }
        }
        if (rep.getOauthClients() != null) {
            for (ClientRepresentation clientRep : rep.getOauthClients()) {
                if (!clientRep.getName().equals(clientId)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRealmRole(RealmRepresentation rep, String roleName) {
        if (rep.getRoles() == null || rep.getRoles().getRealm() == null) {
            return false;
        }
        for (RoleRepresentation role : rep.getRoles().getRealm()) {
            if (!roleName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasClientScope(RealmRepresentation rep, String clientScopeName) {
        if (rep.getClientScopes() == null) {
            return false;
        }
        for (ClientScopeRepresentation clientScope : rep.getClientScopes()) {
            if (!clientScopeName.equals(clientScope.getName())) continue;
            return true;
        }
        return false;
    }

    private void setupAuthorizationServices(RealmModel realm) {
        KeycloakModelUtils.setupAuthorizationServices((RealmModel)realm);
    }

    private void setupClientRegistrations(RealmModel realm) {
        DefaultClientRegistrationPolicies.addDefaultPolicies(realm);
    }

    private void fireRealmPostCreate(final RealmModel realm) {
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmPostCreateEvent(){

            public RealmModel getCreatedRealm() {
                return realm;
            }

            public KeycloakSession getKeycloakSession() {
                return RealmManager.this.session;
            }
        });
    }

    public void setupClientServiceAccountsAndAuthorizationOnImport(RealmRepresentation rep, boolean skipUserDependent) {
        List clients = rep.getClients();
        if (clients != null && !skipUserDependent) {
            ClientManager clientManager = new ClientManager(this);
            for (ClientRepresentation client : clients) {
                RealmModel realmModel = this.getRealmByName(rep.getRealm());
                ClientModel clientModel = Optional.ofNullable(client.getId()).map(arg_0 -> ((RealmModel)realmModel).getClientById(arg_0)).orElseGet(() -> realmModel.getClientByClientId(client.getClientId()));
                if (clientModel == null) {
                    throw new RuntimeException("Cannot find provided client by dir import.");
                }
                UserModel serviceAccount = null;
                if (clientModel.isServiceAccountsEnabled() && (serviceAccount = this.getSession().users().getServiceAccount(clientModel)) == null) {
                    clientManager.enableServiceAccount(clientModel);
                }
                if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION) || !Boolean.TRUE.equals(client.getAuthorizationServicesEnabled())) continue;
                RepresentationToModel.createResourceServer((ClientModel)clientModel, (KeycloakSession)this.session, (serviceAccount == null ? 1 : 0) != 0);
                RepresentationToModel.importAuthorizationSettings((ClientRepresentation)client, (ClientModel)clientModel, (KeycloakSession)this.session);
            }
        }
    }

    public void setDefaultsForNewRealm(RealmModel realm) {
        this.setupRealmDefaults(realm);
        KeycloakModelUtils.setupDefaultRole((RealmModel)realm, (String)("default-roles-" + realm.getName().toLowerCase()));
        this.setupRealmAdminManagement(realm);
        this.setupAccountManagement(realm);
        this.setupBrokerService(realm);
        this.setupAdminConsole(realm);
        this.setupAdminConsoleLocaleMapper(realm);
        this.setupAdminCli(realm);
        this.setupAuthenticationFlows(realm);
        this.setupRequiredActions(realm);
        this.setupOfflineTokens(realm, null);
        this.createDefaultClientScopes(realm);
        this.setupAuthorizationServices(realm);
        this.setupClientRegistrations(realm);
        this.session.clientPolicy().setupClientPoliciesOnCreatedRealm(realm);
        DefaultKeyProviders.createProviders((RealmModel)realm);
    }
}

