/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.infinispan.quarkus.hibernate.cache.CollectionDataAccessImpl;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalDataAccess;
import org.infinispan.quarkus.hibernate.cache.InternalRegion;
import org.infinispan.quarkus.hibernate.cache.InternalRegionImpl;
import org.infinispan.quarkus.hibernate.cache.NonStrictDataAccess;
import org.infinispan.quarkus.hibernate.cache.PutFromLoadValidator;
import org.infinispan.quarkus.hibernate.cache.ReadOnlyEntityDataAccess;
import org.infinispan.quarkus.hibernate.cache.ReadOnlyNaturalDataAccess;
import org.infinispan.quarkus.hibernate.cache.ReadWriteEntityDataAccess;
import org.infinispan.quarkus.hibernate.cache.ReadWriteNaturalDataAccess;
import org.infinispan.quarkus.hibernate.cache.StrictDataAccess;
import org.infinispan.quarkus.hibernate.cache.VersionedEntry;
import org.jboss.logging.Logger;

final class DomainDataRegionImpl
implements DomainDataRegion,
ExtendedStatisticsSupport {
    private static final Logger log = Logger.getLogger(DomainDataRegionImpl.class);
    private final InternalCache cache;
    private final DomainDataRegionConfig config;
    private final CacheKeysFactory cacheKeysFactory;
    private final RegionFactory regionFactory;
    private final InternalRegion internalRegion;
    private Strategy strategy;
    private PutFromLoadValidator validator;
    private Predicate<Map.Entry> filter;

    public long getElementCountInMemory() {
        return this.cache.size(this.filter);
    }

    public long getElementCountOnDisk() {
        return Long.MIN_VALUE;
    }

    public long getSizeInMemory() {
        return Long.MIN_VALUE;
    }

    DomainDataRegionImpl(InternalCache cache, DomainDataRegionConfig config, CacheKeysFactory cacheKeysFactory, RegionFactory regionFactory) {
        this.cache = cache;
        this.config = config;
        this.cacheKeysFactory = cacheKeysFactory;
        this.regionFactory = regionFactory;
        this.internalRegion = new InternalRegionImpl((Region)this);
    }

    CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public EntityDataAccess getEntityDataAccess(NavigableRole rootEntityRole) {
        EntityDataCachingConfig entityConfig = (EntityDataCachingConfig)DomainDataRegionImpl.findConfig(this.config.getEntityCaching(), rootEntityRole);
        AccessType accessType = entityConfig.getAccessType();
        Comparator comparator = entityConfig.isVersioned() ? (Comparator)entityConfig.getVersionComparatorAccess().get() : null;
        InternalDataAccess internal = this.createInternalDataAccess(accessType, comparator);
        if (accessType == AccessType.READ_ONLY || !entityConfig.isMutable()) {
            return new ReadOnlyEntityDataAccess(internal, this);
        }
        return new ReadWriteEntityDataAccess(internal, this);
    }

    private static <T extends DomainDataCachingConfig> T findConfig(List<T> configs, NavigableRole role) {
        return (T)configs.stream().filter(c -> c.getNavigableRole().equals((Object)role)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find configuration for " + role));
    }

    private synchronized InternalDataAccess createInternalDataAccess(AccessType accessType, Comparator<Object> comparator) {
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            this.prepareForVersionedEntries();
            return new NonStrictDataAccess(this.cache, this.internalRegion, comparator, this.regionFactory);
        }
        this.prepareForValidation();
        return new StrictDataAccess(this.cache, this.validator, this.internalRegion);
    }

    private void prepareForValidation() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VALIDATION);
            return;
        }
        this.validator = new PutFromLoadValidator(this.cache, this.config.getRegionName(), this.regionFactory);
        this.strategy = Strategy.VALIDATION;
    }

    private void prepareForVersionedEntries() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VERSIONED_ENTRIES);
            return;
        }
        this.filter = VersionedEntry.EXCLUDE_EMPTY_VERSIONED_ENTRY;
        for (EntityDataCachingConfig entityConfig : this.config.getEntityCaching()) {
            if (!entityConfig.isVersioned()) continue;
            for (NavigableRole role : entityConfig.getCachedTypes()) {
                this.internalRegion.addComparator(role.getNavigableName(), (Comparator)entityConfig.getVersionComparatorAccess().get());
            }
        }
        for (CollectionDataCachingConfig collectionConfig : this.config.getCollectionCaching()) {
            if (!collectionConfig.isVersioned()) continue;
            this.internalRegion.addComparator(collectionConfig.getNavigableRole().getNavigableName(), collectionConfig.getOwnerVersionComparator());
        }
        this.strategy = Strategy.VERSIONED_ENTRIES;
    }

    public NaturalIdDataAccess getNaturalIdDataAccess(NavigableRole rootEntityRole) {
        NaturalIdDataCachingConfig naturalIdConfig = (NaturalIdDataCachingConfig)DomainDataRegionImpl.findConfig(this.config.getNaturalIdCaching(), rootEntityRole);
        AccessType accessType = naturalIdConfig.getAccessType();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            accessType = AccessType.READ_WRITE;
        }
        InternalDataAccess internal = this.createInternalDataAccess(accessType, null);
        if (accessType == AccessType.READ_ONLY || !naturalIdConfig.isMutable()) {
            return new ReadOnlyNaturalDataAccess(internal, this);
        }
        return new ReadWriteNaturalDataAccess(internal, this);
    }

    public CollectionDataAccess getCollectionDataAccess(NavigableRole collectionRole) {
        CollectionDataCachingConfig collectionConfig = (CollectionDataCachingConfig)DomainDataRegionImpl.findConfig(this.config.getCollectionCaching(), collectionRole);
        AccessType accessType = collectionConfig.getAccessType();
        InternalDataAccess accessDelegate = this.createInternalDataAccess(accessType, collectionConfig.getOwnerVersionComparator());
        return new CollectionDataAccessImpl(accessType, accessDelegate, this);
    }

    public String getName() {
        return this.config.getRegionName();
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public void destroy() {
    }

    public void clear() {
        this.internalRegion.beginInvalidation();
        this.runInvalidation();
        this.internalRegion.endInvalidation();
    }

    private void runInvalidation() {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case VALIDATION: {
                log.tracef("Non-transactional, clear in one go", new Object[0]);
                this.cache.invalidateAll();
                break;
            }
            case VERSIONED_ENTRIES: {
                VersionedEntry evict = new VersionedEntry(this.regionFactory.nextTimestamp(), VersionedEntry.TOMBSTONE_LIFESPAN);
                this.removeEntries(entry -> this.cache.put(entry.getKey(), evict));
            }
        }
    }

    private void removeEntries(Consumer<Map.Entry> remover) {
        this.cache.forEach(this.filter, remover);
    }

    private static enum Strategy {
        VALIDATION,
        VERSIONED_ENTRIES;

    }
}

