/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.stat.QueryStatistics;

public class QueryStatisticsImpl
implements QueryStatistics {
    private final @UnknownKeyFor @NonNull @Initialized String query;
    private final @UnknownKeyFor @NonNull @Initialized LongAdder cacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder cacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder cachePutCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder executionCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder executionRowCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong executionMaxTime = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong totalExecutionTime = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder planCacheHitCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized LongAdder planCacheMissCount = new LongAdder();
    private final @UnknownKeyFor @NonNull @Initialized AtomicLong planCompilationTotalMicroseconds = new AtomicLong();
    private final @UnknownKeyFor @NonNull @Initialized Lock readLock;
    private final @UnknownKeyFor @NonNull @Initialized Lock writeLock;

    public QueryStatisticsImpl(@UnknownKeyFor @NonNull @Initialized String query) {
        this.query = query;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionCount() {
        return this.executionCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCacheHitCount() {
        return this.cacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCachePutCount() {
        return this.cachePutCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getCacheMissCount() {
        return this.cacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionRowCount() {
        return this.executionRowCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionAvgTime() {
        return (long)this.getExecutionAvgTimeAsDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized double getExecutionAvgTimeAsDouble() {
        this.writeLock.lock();
        try {
            double avgExecutionTime = 0.0;
            long ec = this.executionCount.sum();
            if (ec > 0L) {
                avgExecutionTime = (double)this.totalExecutionTime.get() / (double)ec;
            }
            double d = avgExecutionTime;
            return d;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getExecutionTotalTime() {
        return this.totalExecutionTime.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getPlanCacheHitCount() {
        return this.planCacheHitCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getPlanCacheMissCount() {
        return this.planCacheMissCount.sum();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getPlanCompilationTotalMicroseconds() {
        return this.planCompilationTotalMicroseconds.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executed(@UnknownKeyFor @NonNull @Initialized long rows, @UnknownKeyFor @NonNull @Initialized long time) {
        this.readLock.lock();
        try {
            long old = this.executionMinTime.get();
            while (time < old && !this.executionMinTime.compareAndSet(old, time)) {
                old = this.executionMinTime.get();
            }
            old = this.executionMaxTime.get();
            while (time > old && !this.executionMaxTime.compareAndSet(old, time)) {
                old = this.executionMaxTime.get();
            }
            this.executionCount.increment();
            this.executionRowCount.add(rows);
            this.totalExecutionTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    void compiled(@UnknownKeyFor @NonNull @Initialized long microseconds) {
        this.planCacheMissCount.increment();
        this.planCompilationTotalMicroseconds.addAndGet(microseconds);
    }

    void incrementCacheHitCount() {
        this.cacheHitCount.increment();
    }

    void incrementCacheMissCount() {
        this.cacheMissCount.increment();
    }

    void incrementCachePutCount() {
        this.cachePutCount.increment();
    }

    void incrementPlanCacheHitCount() {
        this.planCacheHitCount.increment();
    }

    void incrementPlanCacheMissCount() {
        this.planCacheMissCount.increment();
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "QueryStatistics[query=" + this.query + ",cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",planCacheHitCount=" + this.planCacheHitCount + ",planCacheMissCount=" + this.planCacheMissCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.getExecutionAvgTime() + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + "]";
    }
}

