/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Path;
import org.keycloak.admin.ui.rest.AuthenticationManagementResource;
import org.keycloak.admin.ui.rest.AvailableRoleMappingResource;
import org.keycloak.admin.ui.rest.BruteForceUsersResource;
import org.keycloak.admin.ui.rest.EffectiveRoleMappingResource;
import org.keycloak.admin.ui.rest.SessionsResource;
import org.keycloak.admin.ui.rest.UIRealmResource;
import org.keycloak.admin.ui.rest.UIRealmsResource;
import org.keycloak.admin.ui.rest.UsersResource;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public final class AdminExtResource {
    private KeycloakSession session;
    private RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;

    public AdminExtResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @Path(value="/authentication-management")
    public AuthenticationManagementResource authenticationManagement() {
        return new AuthenticationManagementResource(this.session, this.realm, this.auth);
    }

    @Path(value="/brute-force-user")
    public BruteForceUsersResource bruteForceUsers() {
        return new BruteForceUsersResource(this.session, this.realm, this.auth);
    }

    @Path(value="/available-roles")
    public AvailableRoleMappingResource availableRoles() {
        return new AvailableRoleMappingResource(this.session, this.realm, this.auth);
    }

    @Path(value="/effective-roles")
    public EffectiveRoleMappingResource effectiveRoles() {
        return new EffectiveRoleMappingResource(this.session, this.realm, this.auth);
    }

    @Path(value="/sessions")
    public SessionsResource sessions() {
        return new SessionsResource(this.session, this.realm, this.auth);
    }

    @Path(value="/realms")
    public UIRealmsResource realms() {
        return new UIRealmsResource(this.session, this.auth);
    }

    @Path(value="/")
    public UIRealmResource realm() {
        return new UIRealmResource(this.session, this.auth, this.adminEvent);
    }

    @Path(value="/users")
    public UsersResource users() {
        return new UsersResource(this.session);
    }
}

