/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import java.io.PrintStream;
import java.time.Instant;
import java.util.Map;

public final class DiagnosticPrinter {
    public static void printDiagnostics(PrintStream w) {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        w.println(Instant.now().toString());
        w.println("Thread dump follows:");
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            w.println();
            Thread thread = entry.getKey();
            StackTraceElement[] stackTrace = entry.getValue();
            w.print('\"');
            w.print(thread.getName());
            w.print("\" #");
            w.print(thread.getId());
            w.print(" ");
            if (thread.isDaemon()) {
                w.print("daemon ");
            }
            w.print("prio=");
            w.print(thread.getPriority());
            w.print("   java.lang.thread.State: ");
            w.println((Object)thread.getState());
            for (StackTraceElement element : stackTrace) {
                w.print("\tat ");
                w.print(element.getClassName());
                w.print('.');
                w.print(element.getMethodName());
                w.print('(');
                String fileName = element.getFileName();
                w.print(fileName == null ? "unknown source" : fileName);
                int lineNumber = element.getLineNumber();
                if (lineNumber > 0) {
                    w.print(':');
                    w.print(lineNumber);
                }
                w.println(')');
            }
        }
    }
}

