/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.TestAnnotationBuildItem;
import io.quarkus.deployment.builditem.TestClassBeanBuildItem;
import io.quarkus.deployment.builditem.TestProfileBuildItem;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class TestsAsBeansProcessor {
    private static final DotName QUARKUS_TEST_PROFILE = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusTestProfile");

    @BuildStep
    public void testAnnotations(List<TestAnnotationBuildItem> items, BuildProducer<BeanDefiningAnnotationBuildItem> producer) {
        for (TestAnnotationBuildItem item : items) {
            producer.produce((BuildItem)new BeanDefiningAnnotationBuildItem(DotName.createSimple((String)item.getAnnotationClassName())));
        }
    }

    @BuildStep
    public void testClassBeans(List<TestClassBeanBuildItem> items, BuildProducer<AdditionalBeanBuildItem> producer) {
        if (items.isEmpty()) {
            return;
        }
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder();
        for (TestClassBeanBuildItem item : items) {
            builder.addBeanClass(item.getTestClassName());
        }
        producer.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsTest.class})
    AnnotationsTransformerBuildItem vetoTestProfileBeans(Optional<TestProfileBuildItem> testProfile, final CustomScopeAnnotationsBuildItem customScopes, final CombinedIndexBuildItem index) {
        if (index.getIndex().getAllKnownImplementors(QUARKUS_TEST_PROFILE).isEmpty()) {
            return null;
        }
        final Set<DotName> currentTestProfileHierarchy = TestsAsBeansProcessor.initTestProfileHierarchy(testProfile, index.getComputingIndex());
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz;
                AnnotationTarget target = context.getTarget();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    this.vetoProducerIfNecessary(target.asMethod().declaringClass(), context);
                } else if (target.kind() == AnnotationTarget.Kind.FIELD) {
                    this.vetoProducerIfNecessary(target.asField().declaringClass(), context);
                } else if (target.kind() == AnnotationTarget.Kind.CLASS && (clazz = target.asClass()).nestingType() == ClassInfo.NestingType.INNER && Modifier.isStatic(clazz.flags())) {
                    ClassInfo enclosing = index.getComputingIndex().getClassByName(clazz.enclosingClass());
                    if (customScopes.isScopeIn(context.getAnnotations()) && TestsAsBeansProcessor.isTestProfileClass(enclosing, index.getComputingIndex()) && !currentTestProfileHierarchy.contains(enclosing.name())) {
                        ((Transformation)context.transform().add(DotNames.VETOED, new AnnotationValue[0])).done();
                    }
                }
            }

            private void vetoProducerIfNecessary(ClassInfo declaringClass, AnnotationsTransformer.TransformationContext context) {
                if (Annotations.contains((Collection)context.getAnnotations(), (DotName)DotNames.PRODUCES) && TestsAsBeansProcessor.isTestProfileClass(declaringClass, index.getComputingIndex()) && !currentTestProfileHierarchy.contains(declaringClass.name())) {
                    ((Transformation)context.transform().add(DotNames.VETOED_PRODUCER, new AnnotationValue[0])).done();
                }
            }
        });
    }

    private static Set<DotName> initTestProfileHierarchy(Optional<TestProfileBuildItem> testProfile, IndexView index) {
        Set<DotName> ret = Set.of();
        if (testProfile.isPresent()) {
            DotName testProfileClassName = DotName.createSimple((String)testProfile.get().getTestProfileClassName());
            ret = Set.of(testProfileClassName);
            ClassInfo testProfileClass = index.getClassByName(testProfile.get().getTestProfileClassName());
            if (testProfileClass != null && !testProfileClass.superName().equals((Object)DotName.OBJECT_NAME)) {
                ret = new HashSet<DotName>();
                ret.add(testProfileClassName);
                DotName superName = testProfileClass.superName();
                while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                    ret.add(superName);
                    ClassInfo superClass = index.getClassByName(superName);
                    if (superClass != null) {
                        superName = superClass.superName();
                        continue;
                    }
                    superName = null;
                }
            }
        }
        return ret;
    }

    private static boolean isTestProfileClass(ClassInfo clazz, IndexView index) {
        if (clazz.interfaceNames().contains(QUARKUS_TEST_PROFILE)) {
            return true;
        }
        DotName superName = clazz.superName();
        while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
            ClassInfo superClass = index.getClassByName(superName);
            if (superClass != null) {
                if (superClass.interfaceNames().contains(QUARKUS_TEST_PROFILE)) {
                    return true;
                }
                superName = superClass.superName();
                continue;
            }
            superName = null;
        }
        return false;
    }
}

