/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.BFILE;
import oracle.sql.Datum;

class BfileAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 530;

    BfileAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.BFILE, stmt, 530, isStoredInBindData);
        this.init(stmt, 114, 114, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    BfileAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BFILE, stmt, 530, false);
        this.init(stmt, 114, 114, form, false);
        this.initForDescribe(114, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getBFILE(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return this.getBFILE(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getBFILE(currentRow);
    }

    @Override
    BFILE getBFILE(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        BFILE result = new BFILE(this.statement.connection, this.getBytesInternal(currentRow));
        if (this.isPrefetched()) {
            result.setLength(this.getPrefetchedLength(currentRow));
        }
        return result;
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        BFILE file = this.getBFILE(currentRow);
        if (file == null) {
            return null;
        }
        return file.asciiStreamValue();
    }

    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        BFILE file = this.getBFILE(currentRow);
        if (file == null) {
            return null;
        }
        return file.characterStreamValue();
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        BFILE file = this.getBFILE(currentRow);
        if (file == null) {
            return null;
        }
        return file.getBinaryStream();
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        BFILE lob = this.getBFILE(currentRow);
        if (lob == null) {
            return null;
        }
        InputStream r = lob.getBinaryStream();
        int size = 4096;
        int length = 0;
        ByteArrayOutputStream w = new ByteArrayOutputStream(size);
        byte[] buffer = new byte[size];
        try {
            while ((length = r.read(buffer)) != -1) {
                w.write(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
        }
        catch (IndexOutOfBoundsException x) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
        }
        return w.toByteArray();
    }
}

