/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodDescriptor;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;
import org.objectweb.asm.ClassVisitor;

final class Methods {
    private static final Logger LOGGER = Logger.getLogger(Methods.class);
    public static final String INIT = "<init>";
    public static final String CLINIT = "<clinit>";
    static final int BRIDGE = 64;
    public static final String TO_STRING = "toString";
    static final Set<String> IGNORED_METHODS = Set.of("<init>", "<clinit>");
    static final List<DotName> OBSERVER_PRODUCER_ANNOTATIONS = List.of(DotNames.OBSERVES, DotNames.OBSERVES_ASYNC, DotNames.PRODUCES);

    private Methods() {
    }

    static boolean isBridge(MethodInfo method) {
        return (method.flags() & 0x40) != 0;
    }

    static void addDelegatingMethods(IndexView index, ClassInfo classInfo, Map<MethodKey, MethodInfo> methods, Map<String, Set<MethodKey>> methodsFromWhichToRemoveFinal, boolean transformUnproxyableClasses) {
        if (classInfo != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : classInfo.methods()) {
                if (Methods.skipForClientProxy(method, transformUnproxyableClasses, methodsFromWhichToRemoveFinal)) continue;
                methods.computeIfAbsent(new MethodKey(method), key -> {
                    Type returnType = key.method.returnType();
                    Type[] params = new Type[key.method.parametersCount()];
                    for (int i = 0; i < params.length; ++i) {
                        params[i] = key.method.parameterType(i);
                    }
                    List typeVariables = key.method.typeParameters();
                    return MethodInfo.create((ClassInfo)classInfo, (String)key.method.name(), (Type[])params, (Type)returnType, (short)key.method.flags(), (TypeVariable[])typeVariables.toArray(new TypeVariable[0]), (Type[])key.method.exceptions().toArray(Type.EMPTY_ARRAY));
                });
            }
            if (classInfo.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(index, classInfo.superName())) != null) {
                Methods.addDelegatingMethods(index, superClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
            for (DotName interfaceName : classInfo.interfaceNames()) {
                ClassInfo interfaceClassInfo = IndexClassLookupUtils.getClassByName(index, interfaceName);
                if (interfaceClassInfo == null) continue;
                Methods.addDelegatingMethods(index, interfaceClassInfo, methods, methodsFromWhichToRemoveFinal, transformUnproxyableClasses);
            }
        }
    }

    private static boolean skipForClientProxy(MethodInfo method, boolean transformUnproxyableClasses, Map<String, Set<MethodKey>> methodsFromWhichToRemoveFinal) {
        if (Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags())) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        if (method.declaringClass().name().equals((Object)DotNames.OBJECT) && !method.name().equals(TO_STRING)) {
            return true;
        }
        if (Modifier.isFinal(method.flags())) {
            String className = method.declaringClass().name().toString();
            if (!className.startsWith("java.")) {
                if (transformUnproxyableClasses && methodsFromWhichToRemoveFinal != null) {
                    methodsFromWhichToRemoveFinal.computeIfAbsent(className, k -> new HashSet()).add(new MethodKey(method));
                    return false;
                }
                LOGGER.warn((Object)String.format("Final method %s.%s() is ignored during proxy generation and should never be invoked upon the proxy instance!", className, method.name()));
            } else {
                LOGGER.warn((Object)String.format("JDK class %s with final method %s() cannot be proxied and is not transformable. This method will be ignored during proxy generation and should never be invoked upon the proxy instance!", className, method.name()));
            }
            return true;
        }
        return false;
    }

    static boolean skipForDelegateSubclass(MethodInfo method) {
        if (Modifier.isStatic(method.flags()) || method.isSynthetic()) {
            return true;
        }
        if (IGNORED_METHODS.contains(method.name())) {
            return true;
        }
        return method.declaringClass().name().equals((Object)DotNames.OBJECT);
    }

    static boolean isDefault(MethodInfo method) {
        return (method.flags() & 0x409) == 1 && method.declaringClass().isInterface();
    }

    static boolean isObjectToString(MethodInfo method) {
        return method.declaringClass().name().equals((Object)DotNames.OBJECT) && method.name().equals(TO_STRING);
    }

    static Set<MethodInfo> addInterceptedMethodCandidates(BeanInfo bean, Map<MethodKey, Set<AnnotationInstance>> candidates, List<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        BeanDeployment beanDeployment = bean.getDeployment();
        ClassInfo classInfo = bean.getTarget().get().asClass();
        return Methods.addInterceptedMethodCandidates(beanDeployment, classInfo, classInfo, candidates, Set.copyOf(classLevelBindings), bytecodeTransformerConsumer, transformUnproxyableClasses, new SubclassSkipPredicate(beanDeployment.getAssignabilityCheck()::isAssignableFrom, beanDeployment.getBeanArchiveIndex(), beanDeployment.getObserverAndProducerMethods(), beanDeployment.getAnnotationStore()), false, new HashSet<MethodKey>(), bean.hasAroundInvokes());
    }

    private static Set<MethodInfo> addInterceptedMethodCandidates(BeanDeployment beanDeployment, ClassInfo classInfo, ClassInfo originalClassInfo, Map<MethodKey, Set<AnnotationInstance>> candidates, Set<AnnotationInstance> classLevelBindings, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses, SubclassSkipPredicate skipPredicate, boolean ignoreMethodLevelBindings, Set<MethodKey> noClassInterceptorsMethods, boolean targetHasAroundInvokes) {
        ClassInfo superClassInfo;
        HashSet<MethodKey> methodsFromWhichToRemoveFinal = new HashSet<MethodKey>();
        HashSet<MethodInfo> finalMethodsFoundAndNotChanged = new HashSet<MethodInfo>();
        skipPredicate.startProcessing(classInfo, originalClassInfo);
        for (MethodInfo method : classInfo.methods()) {
            boolean possiblyIntercepted;
            MethodKey key = new MethodKey(method);
            if (candidates.containsKey(key)) continue;
            Set<AnnotationInstance> bindings = Methods.mergeBindings(beanDeployment, originalClassInfo, classLevelBindings, ignoreMethodLevelBindings, method, noClassInterceptorsMethods);
            boolean bl = possiblyIntercepted = !bindings.isEmpty() || targetHasAroundInvokes;
            if (skipPredicate.test(method)) continue;
            boolean addToCandidates = true;
            if (Modifier.isFinal(method.flags()) && possiblyIntercepted) {
                if (transformUnproxyableClasses && !KotlinUtils.isNoninterceptableKotlinMethod(method)) {
                    methodsFromWhichToRemoveFinal.add(new MethodKey(method));
                } else {
                    addToCandidates = false;
                    finalMethodsFoundAndNotChanged.add(method);
                }
            }
            if (!addToCandidates) continue;
            candidates.putIfAbsent(key, bindings);
        }
        skipPredicate.methodsProcessed();
        if (!methodsFromWhichToRemoveFinal.isEmpty()) {
            bytecodeTransformerConsumer.accept(new BytecodeTransformer(classInfo.name().toString(), new RemoveFinalFromMethod(methodsFromWhichToRemoveFinal)));
        }
        if (!classInfo.superName().equals((Object)DotNames.OBJECT) && (superClassInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            finalMethodsFoundAndNotChanged.addAll(Methods.addInterceptedMethodCandidates(beanDeployment, superClassInfo, classInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, skipPredicate, ignoreMethodLevelBindings, noClassInterceptorsMethods, targetHasAroundInvokes));
        }
        for (DotName i : classInfo.interfaceNames()) {
            ClassInfo interfaceInfo = IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), i);
            if (interfaceInfo == null) continue;
            Methods.addInterceptedMethodCandidates(beanDeployment, interfaceInfo, originalClassInfo, candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses, skipPredicate, true, noClassInterceptorsMethods, targetHasAroundInvokes);
        }
        return finalMethodsFoundAndNotChanged;
    }

    private static Set<AnnotationInstance> mergeBindings(BeanDeployment beanDeployment, ClassInfo classInfo, Set<AnnotationInstance> classLevelBindings, boolean ignoreMethodLevelBindings, MethodInfo method, Set<MethodKey> noClassInterceptorsMethods) {
        Set<Object> merged;
        MethodKey key = new MethodKey(method);
        if (beanDeployment.getAnnotation((AnnotationTarget)method, DotNames.NO_CLASS_INTERCEPTORS) != null || noClassInterceptorsMethods.contains(key)) {
            noClassInterceptorsMethods.add(key);
            classLevelBindings = Set.of();
        }
        if (ignoreMethodLevelBindings) {
            return classLevelBindings;
        }
        Collection<AnnotationInstance> methodAnnotations = beanDeployment.getAnnotations((AnnotationTarget)method);
        if (methodAnnotations.isEmpty()) {
            return classLevelBindings;
        }
        ArrayList<AnnotationInstance> methodLevelBindings = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotation : methodAnnotations) {
            methodLevelBindings.addAll(beanDeployment.extractInterceptorBindings(annotation));
        }
        if (methodLevelBindings.isEmpty()) {
            merged = classLevelBindings;
        } else {
            merged = Methods.mergeMethodAndClassLevelBindings(methodLevelBindings, classLevelBindings);
            if (Modifier.isPrivate(method.flags()) && !Annotations.containsAny(methodAnnotations, OBSERVER_PRODUCER_ANNOTATIONS)) {
                String message = methodLevelBindings.size() == 1 ? String.format("%s will have no effect on method %s.%s() because the method is private.", methodLevelBindings.iterator().next(), classInfo.name(), method.name()) : String.format("Annotations %s will have no effect on method %s.%s() because the method is private.", methodLevelBindings.stream().map(AnnotationInstance::toString).collect(Collectors.joining(",")), classInfo.name(), method.name());
                if (beanDeployment.failOnInterceptedPrivateMethod) {
                    throw new DeploymentException(message + " Either remove the annotation from the method, or turn this exception into a simple warning by setting configuration property 'quarkus.arc.fail-on-intercepted-private-method' to 'false'.");
                }
                LOGGER.warn((Object)message);
            }
        }
        return merged;
    }

    static Set<AnnotationInstance> mergeMethodAndClassLevelBindings(Collection<AnnotationInstance> methodLevelBindings, Set<AnnotationInstance> classLevelBindings) {
        if (methodLevelBindings.isEmpty()) {
            return classLevelBindings;
        }
        HashSet<DotName> methodLevelNames = new HashSet<DotName>();
        for (AnnotationInstance methodLevelBinding : methodLevelBindings) {
            methodLevelNames.add(methodLevelBinding.name());
        }
        HashSet<AnnotationInstance> result = new HashSet<AnnotationInstance>(methodLevelBindings);
        for (AnnotationInstance classLevelBinding : classLevelBindings) {
            if (methodLevelNames.contains(classLevelBinding.name())) continue;
            result.add(classLevelBinding);
        }
        return result;
    }

    static boolean isOverriden(MethodKey method, Set<MethodKey> previousMethods) {
        return previousMethods.contains(method);
    }

    static void addDelegateTypeMethods(IndexView index, ClassInfo delegateTypeClass, Set<MethodKey> methods) {
        if (delegateTypeClass != null) {
            ClassInfo superClassInfo;
            for (MethodInfo method : delegateTypeClass.methods()) {
                if (Methods.skipForDelegateSubclass(method)) continue;
                methods.add(new MethodKey(method));
            }
            for (Type interfaceType : delegateTypeClass.interfaceTypes()) {
                ClassInfo interfaceClassInfo = IndexClassLookupUtils.getClassByName(index, interfaceType.name());
                if (interfaceClassInfo == null) continue;
                Methods.addDelegateTypeMethods(index, interfaceClassInfo, methods);
            }
            if (delegateTypeClass.superClassType() != null && (superClassInfo = IndexClassLookupUtils.getClassByName(index, delegateTypeClass.superName())) != null) {
                Methods.addDelegateTypeMethods(index, superClassInfo, methods);
            }
        }
    }

    static boolean containsTypeVariableParameter(MethodInfo method) {
        for (Type param : method.parameterTypes()) {
            if (!Types.containsTypeVariable(param)) continue;
            return true;
        }
        return false;
    }

    static boolean descriptorMatches(MethodDescriptor d1, MethodDescriptor d2) {
        return d1.getName().equals(d2.getName()) && d1.getDescriptor().equals(d2.getDescriptor());
    }

    static class MethodKey {
        final String name;
        final List<DotName> params;
        final DotName returnType;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = Objects.requireNonNull(method, "Method must not be null");
            this.name = method.name();
            this.returnType = method.returnType().name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameterTypes()) {
                this.params.add(i.name());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return Objects.equals(this.name, methodKey.name) && Objects.equals(this.params, methodKey.params) && Objects.equals(this.returnType, methodKey.returnType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.params, this.returnType);
        }
    }

    static class SubclassSkipPredicate
    implements Predicate<MethodInfo> {
        private static final List<DotName> INTERCEPTOR_ANNOTATIONS = List.of(DotNames.AROUND_INVOKE, DotNames.POST_CONSTRUCT, DotNames.PRE_DESTROY);
        private final BiFunction<Type, Type, Boolean> assignableFromFun;
        private final IndexView beanArchiveIndex;
        private final Set<MethodInfo> producersAndObservers;
        private final AnnotationStore annotationStore;
        private ClassInfo clazz;
        private ClassInfo originalClazz;
        private List<MethodInfo> regularMethods;
        private Set<MethodInfo> bridgeMethods = new HashSet<MethodInfo>();

        public SubclassSkipPredicate(BiFunction<Type, Type, Boolean> assignableFromFun, IndexView beanArchiveIndex, Set<MethodInfo> producersAndObservers, AnnotationStore annotationStore) {
            this.assignableFromFun = assignableFromFun;
            this.beanArchiveIndex = beanArchiveIndex;
            this.producersAndObservers = producersAndObservers;
            this.annotationStore = annotationStore;
        }

        void startProcessing(ClassInfo clazz, ClassInfo originalClazz) {
            this.clazz = clazz;
            this.originalClazz = originalClazz;
            this.regularMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : clazz.methods()) {
                if (Modifier.isAbstract(method.flags()) || method.isSynthetic() || Methods.isBridge(method)) continue;
                this.regularMethods.add(method);
            }
        }

        void methodsProcessed() {
            for (MethodInfo method : this.clazz.methods()) {
                if (!Methods.isBridge(method)) continue;
                this.bridgeMethods.add(method);
            }
        }

        @Override
        public boolean test(MethodInfo method) {
            if (Methods.isBridge(method)) {
                return this.hasImplementation(method);
            }
            if (method.isSynthetic()) {
                return true;
            }
            if (Modifier.isPrivate(method.flags()) && !this.producersAndObservers.contains(method)) {
                return true;
            }
            if (Modifier.isStatic(method.flags())) {
                return true;
            }
            if (IGNORED_METHODS.contains(method.name())) {
                return true;
            }
            if (method.declaringClass().name().equals((Object)DotNames.OBJECT)) {
                return true;
            }
            if (this.annotationStore.hasAnyAnnotation((AnnotationTarget)method, INTERCEPTOR_ANNOTATIONS)) {
                return true;
            }
            if (InterceptorInfo.hasInterceptorMethodParameter(method) && InterceptorInfo.isInterceptorMethodOverriden(this.regularMethods, method)) {
                return true;
            }
            if (this.isOverridenByBridgeMethod(method)) {
                return true;
            }
            if (Modifier.isInterface(this.clazz.flags()) && Modifier.isInterface(method.declaringClass().flags()) && Modifier.isPublic(method.flags()) && !Modifier.isAbstract(method.flags()) && !Modifier.isStatic(method.flags())) {
                return false;
            }
            List parameters = method.parameterTypes();
            if (!parameters.isEmpty() && this.beanArchiveIndex != null) {
                String originalClassPackage = DotNames.packageName(this.originalClazz.name());
                for (Type type : parameters) {
                    ClassInfo param;
                    if (type.kind() == Type.Kind.PRIMITIVE) continue;
                    DotName typeName = type.name();
                    if (type.kind() == Type.Kind.ARRAY) {
                        Type componentType = type.asArrayType().constituent();
                        if (componentType.kind() == Type.Kind.PRIMITIVE) continue;
                        typeName = componentType.name();
                    }
                    if ((param = this.beanArchiveIndex.getClassByName(typeName)) == null) {
                        LOGGER.warn((Object)String.format("Parameter type info not available: %s - unable to validate the parameter type's visibility for method %s declared on %s", type.name(), method.name(), method.declaringClass().name()));
                        continue;
                    }
                    if (Modifier.isPublic(param.flags()) || Modifier.isProtected(param.flags()) || DotNames.packageName(param.name()).equals(originalClassPackage)) continue;
                    LOGGER.warn((Object)String.format("A method %s() declared on %s has a non-public parameter of type %s which prevents it from being intercepted. Please change the parameter type visibility in order to make it intercepted.", method.name(), method.declaringClass().name(), type));
                    return true;
                }
            }
            return false;
        }

        private boolean hasImplementation(MethodInfo bridge) {
            for (MethodInfo declaredMethod : this.regularMethods) {
                if (!bridge.name().equals(declaredMethod.name())) continue;
                List params = declaredMethod.parameterTypes();
                List bridgeParams = bridge.parameterTypes();
                if (params.size() != bridgeParams.size()) continue;
                boolean paramsNotMatching = false;
                for (int i = 0; i < bridgeParams.size(); ++i) {
                    Type param;
                    Type bridgeParam = (Type)bridgeParams.get(i);
                    if (this.assignableFromFun.apply(bridgeParam, param = (Type)params.get(i)).booleanValue()) continue;
                    paramsNotMatching = true;
                    break;
                }
                if (paramsNotMatching) continue;
                if (!Modifier.isInterface(this.clazz.flags())) {
                    if (bridge.returnType().name().equals((Object)DotNames.OBJECT) || Modifier.isAbstract(declaredMethod.flags())) {
                        return true;
                    }
                    return this.assignableFromFun.apply(bridge.returnType(), declaredMethod.returnType());
                }
                return true;
            }
            return false;
        }

        private boolean isOverridenByBridgeMethod(MethodInfo method) {
            for (MethodInfo bridge : this.bridgeMethods) {
                if (!method.name().equals(bridge.name()) || !this.parametersMatch(method, bridge)) continue;
                if (Modifier.isInterface(this.clazz.flags())) {
                    return true;
                }
                if (bridge.returnType().name().equals((Object)DotNames.OBJECT) || Modifier.isAbstract(method.flags())) {
                    return true;
                }
                if (bridge.returnType().kind() == Type.Kind.CLASS && method.returnType().kind() == Type.Kind.TYPE_VARIABLE) {
                    return true;
                }
                return bridge.returnType().equals((Object)method.returnType());
            }
            return false;
        }

        private boolean parametersMatch(MethodInfo method, MethodInfo bridge) {
            List params = method.parameterTypes();
            List bridgeParams = bridge.parameterTypes();
            if (bridgeParams.size() != params.size()) {
                return false;
            }
            for (int i = 0; i < params.size(); ++i) {
                Type param = (Type)params.get(i);
                Type bridgeParam = (Type)bridgeParams.get(i);
                if (bridgeParam.name().equals((Object)param.name())) continue;
                return false;
            }
            return true;
        }
    }

    static class RemoveFinalFromMethod
    implements BiFunction<String, ClassVisitor, ClassVisitor> {
        private final Set<MethodKey> methodsFromWhichToRemoveFinal;

        public RemoveFinalFromMethod(Set<MethodKey> methodsFromWhichToRemoveFinal) {
            this.methodsFromWhichToRemoveFinal = methodsFromWhichToRemoveFinal;
        }

        @Override
        public ClassVisitor apply(String className, ClassVisitor classVisitor) {
            ClassTransformer transformer = new ClassTransformer(className);
            for (MethodKey key : this.methodsFromWhichToRemoveFinal) {
                LOGGER.debug((Object)("Final modifier removed from method " + key.name + " of class " + className));
                transformer.modifyMethod(MethodDescriptor.of((MethodInfo)key.method)).removeModifiers(16);
            }
            return transformer.applyTo(classVisitor);
        }
    }
}

