/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.hibernate.orm.runtime.customized.FormatMapperKind;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class PersistenceUnitDescriptorBuildItem
extends MultiBuildItem {
    private final ParsedPersistenceXmlDescriptor descriptor;
    private final String configurationName;
    private final RecordedConfig config;
    private final String multiTenancySchemaDataSource;
    private final List<RecordableXmlMapping> xmlMappings;
    private final boolean isReactive;
    private final boolean fromPersistenceXml;
    private final Optional<FormatMapperKind> jsonMapper;
    private final Optional<FormatMapperKind> xmlMapper;

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, String configurationName, RecordedConfig config, String multiTenancySchemaDataSource, List<RecordableXmlMapping> xmlMappings, boolean isReactive, boolean fromPersistenceXml, Capabilities capabilities) {
        this.descriptor = descriptor;
        this.configurationName = configurationName;
        this.config = config;
        this.multiTenancySchemaDataSource = multiTenancySchemaDataSource;
        this.xmlMappings = xmlMappings;
        this.isReactive = isReactive;
        this.fromPersistenceXml = fromPersistenceXml;
        this.jsonMapper = this.json(capabilities);
        this.xmlMapper = this.xml(capabilities);
    }

    public Collection<String> getManagedClassNames() {
        return this.descriptor.getManagedClassNames();
    }

    public String getExplicitSqlImportScriptResourceName() {
        return this.descriptor.getProperties().getProperty("jakarta.persistence.sql-load-script-source");
    }

    public String getPersistenceUnitName() {
        return this.descriptor.getName();
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public RecordedConfig getConfig() {
        return this.config;
    }

    public String getMultiTenancySchemaDataSource() {
        return this.multiTenancySchemaDataSource;
    }

    public boolean hasXmlMappings() {
        return !this.xmlMappings.isEmpty();
    }

    public boolean isFromPersistenceXml() {
        return this.fromPersistenceXml;
    }

    public QuarkusPersistenceUnitDefinition asOutputPersistenceUnitDefinition(List<HibernateOrmIntegrationStaticDescriptor> integrationStaticDescriptors) {
        return new QuarkusPersistenceUnitDefinition((PersistenceUnitDescriptor)this.descriptor, this.configurationName, this.config, this.xmlMappings, this.isReactive, this.fromPersistenceXml, this.jsonMapper, this.xmlMapper, integrationStaticDescriptors);
    }

    private Optional<FormatMapperKind> json(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jackson")) {
            return Optional.of(FormatMapperKind.JACKSON);
        }
        if (capabilities.isPresent("io.quarkus.jsonb")) {
            return Optional.of(FormatMapperKind.JSONB);
        }
        return Optional.empty();
    }

    private Optional<FormatMapperKind> xml(Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.jaxb")) {
            return Optional.of(FormatMapperKind.JAXB);
        }
        return Optional.empty();
    }
}

