/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.core.multipart.FormDataParser;
import org.jboss.resteasy.reactive.server.core.multipart.FormParserFactory;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartParser;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;

public class MultiPartParserDefinition
implements FormParserFactory.ParserDefinition<MultiPartParserDefinition> {
    private static final Logger log = Logger.getLogger(MultiPartParserDefinition.class);
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private final Supplier<Executor> executorSupplier;
    private Path tempFileLocation;
    private String defaultCharset = StandardCharsets.UTF_8.displayName();
    private boolean deleteUploadsOnEnd = true;
    private long maxIndividualFileSize = -1L;
    private long fileSizeThreshold;
    private long maxAttributeSize = 2048L;
    private long maxEntitySize = -1L;
    private List<String> fileContentTypes;

    public MultiPartParserDefinition(Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
        this.tempFileLocation = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public MultiPartParserDefinition(Supplier<Executor> executorSupplier, Path tempDir) {
        this.executorSupplier = executorSupplier;
        this.tempFileLocation = tempDir;
    }

    @Override
    public FormDataParser create(ResteasyReactiveRequestContext exchange, Set<String> fileFormNames) {
        String mimeType = exchange.serverRequest().getRequestHeader("Content-Type");
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = HeaderUtil.extractQuotedValueFromHeader((String)mimeType, (String)"boundary");
            if (boundary == null) {
                log.debugf("Could not find boundary in multipart request with ContentType: %s, multipart data will not be available", (Object)mimeType);
                return null;
            }
            final MultiPartUploadHandler parser = new MultiPartUploadHandler(exchange, boundary, this.maxIndividualFileSize, this.fileSizeThreshold, this.defaultCharset, mimeType, this.maxAttributeSize, this.maxEntitySize, fileFormNames);
            exchange.registerCompletionCallback(new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    try {
                        parser.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to close multipart parser", (Throwable)e);
                    }
                }
            });
            return parser;
        }
        return null;
    }

    public long getMaxAttributeSize() {
        return this.maxAttributeSize;
    }

    public MultiPartParserDefinition setMaxAttributeSize(long maxAttributeSize) {
        this.maxAttributeSize = maxAttributeSize;
        return this;
    }

    public boolean isDeleteUploadsOnEnd() {
        return this.deleteUploadsOnEnd;
    }

    public MultiPartParserDefinition setDeleteUploadsOnEnd(boolean deleteUploadsOnEnd) {
        this.deleteUploadsOnEnd = deleteUploadsOnEnd;
        return this;
    }

    public Path getTempFileLocation() {
        return this.tempFileLocation;
    }

    public MultiPartParserDefinition setTempFileLocation(Path tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
        return this;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public MultiPartParserDefinition setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    public long getMaxIndividualFileSize() {
        return this.maxIndividualFileSize;
    }

    public MultiPartParserDefinition setMaxIndividualFileSize(long maxIndividualFileSize) {
        this.maxIndividualFileSize = maxIndividualFileSize;
        return this;
    }

    public MultiPartParserDefinition setFileSizeThreshold(long fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
        return this;
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public MultiPartParserDefinition setMaxEntitySize(long maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
        return this;
    }

    public List<String> getFileContentTypes() {
        return this.fileContentTypes;
    }

    public MultiPartParserDefinition setFileContentTypes(List<String> fileContentTypes) {
        this.fileContentTypes = fileContentTypes;
        return this;
    }

    private final class MultiPartUploadHandler
    implements FormDataParser,
    MultipartParser.PartHandler {
        private final ResteasyReactiveRequestContext exchange;
        private final FormData data;
        private final List<Path> createdFiles = new ArrayList<Path>();
        private final long maxIndividualFileSize;
        private final long fileSizeThreshold;
        private final long maxAttributeSize;
        private final long maxEntitySize;
        private final Set<String> fileFormNames;
        private String defaultEncoding;
        private final ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
        private String currentName;
        private String fileName;
        private Path file;
        private FileChannel fileChannel;
        private CaseInsensitiveMap<String> headers;
        private long currentFileSize;
        private long currentEntitySize;
        private final MultipartParser.ParseState parser;

        private MultiPartUploadHandler(ResteasyReactiveRequestContext exchange, String boundary, long maxIndividualFileSize, long fileSizeThreshold, String defaultEncoding, String contentType, long maxAttributeSize, long maxEntitySize, Set<String> fileFormNames) {
            String value;
            this.exchange = exchange;
            this.maxIndividualFileSize = maxIndividualFileSize;
            this.defaultEncoding = defaultEncoding;
            this.fileSizeThreshold = fileSizeThreshold;
            this.maxAttributeSize = maxAttributeSize;
            this.maxEntitySize = maxEntitySize;
            this.fileFormNames = fileFormNames;
            int maxParameters = 1000;
            this.data = new FormData(maxParameters);
            String charset = defaultEncoding;
            if (contentType != null && (value = HeaderUtil.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                charset = value;
            }
            this.parser = MultipartParser.beginParse(this, boundary.getBytes(StandardCharsets.US_ASCII), charset);
        }

        @Override
        public void parse() throws Exception {
            if (this.exchange.getFormData() != null) {
                return;
            }
            this.exchange.suspend();
            this.exchange.serverRequest().setReadListener(new NonBlockingParseTask(MultiPartParserDefinition.this.executorSupplier.get()));
            this.exchange.serverRequest().resumeRequestInput();
        }

        @Override
        public FormData parseBlocking() throws Exception {
            FormData existing = this.exchange.getFormData();
            if (existing != null) {
                return existing;
            }
            try (InputStream inputStream = this.exchange.getInputStream();){
                int c;
                byte[] buf = new byte[1024];
                while ((c = inputStream.read(buf)) > 0) {
                    this.parser.parse(ByteBuffer.wrap(buf, 0, c));
                }
                if (!this.parser.isComplete()) {
                    throw new IOException("Connection terminated parsing multipart request");
                }
                this.exchange.setFormData(this.data);
            }
            return this.data;
        }

        @Override
        public void beginPart(CaseInsensitiveMap<String> headers) {
            this.currentFileSize = 0L;
            this.headers = headers;
            String disposition = (String)headers.getFirst((Object)"Content-Disposition");
            if (disposition != null && disposition.startsWith("form-data")) {
                this.currentName = HeaderUtil.extractQuotedValueFromHeader((String)disposition, (String)"name");
                this.fileName = HeaderUtil.extractQuotedValueFromHeaderWithEncoding((String)disposition, (String)"filename");
                String contentType = (String)headers.getFirst((Object)"Content-Type");
                if ((this.fileName != null || this.isFileContentType(contentType) || this.fileFormNames.contains(this.currentName)) && this.fileSizeThreshold == 0L) {
                    try {
                        if (MultiPartParserDefinition.this.tempFileLocation != null) {
                            Files.createDirectories(MultiPartParserDefinition.this.tempFileLocation, new FileAttribute[0]);
                            this.file = Files.createTempFile(MultiPartParserDefinition.this.tempFileLocation, "resteasy-reactive", "upload", new FileAttribute[0]);
                        } else {
                            this.file = Files.createTempFile("resteasy-reactive", "upload", new FileAttribute[0]);
                        }
                        this.createdFiles.add(this.file);
                        this.fileChannel = FileChannel.open(this.file, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        private boolean isFileContentType(String contentType) {
            if (contentType == null || MultiPartParserDefinition.this.fileContentTypes == null) {
                return false;
            }
            return MultiPartParserDefinition.this.fileContentTypes.contains(contentType);
        }

        @Override
        public void data(ByteBuffer buffer) throws IOException {
            this.currentFileSize += (long)buffer.remaining();
            this.currentEntitySize += (long)buffer.remaining();
            if (this.maxEntitySize > 0L && this.currentEntitySize > this.maxEntitySize) {
                this.data.deleteFiles();
                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            }
            if (this.maxIndividualFileSize > 0L && this.currentFileSize > this.maxIndividualFileSize) {
                this.data.deleteFiles();
                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            }
            if (this.file == null && this.fileName != null && this.fileSizeThreshold < this.currentFileSize) {
                try {
                    if (MultiPartParserDefinition.this.tempFileLocation != null) {
                        Files.createDirectories(MultiPartParserDefinition.this.tempFileLocation, new FileAttribute[0]);
                        this.file = Files.createTempFile(MultiPartParserDefinition.this.tempFileLocation, "resteasy-reactive", "upload", new FileAttribute[0]);
                    } else {
                        this.file = Files.createTempFile("resteasy-reactive", "upload", new FileAttribute[0]);
                    }
                    this.createdFiles.add(this.file);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file.toFile());
                    this.contentBytes.writeTo(fileOutputStream);
                    this.fileChannel = fileOutputStream.getChannel();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.file == null) {
                while (buffer.hasRemaining()) {
                    this.contentBytes.write(buffer.get());
                }
                if (this.maxAttributeSize > 0L && (long)this.contentBytes.size() > this.maxAttributeSize) {
                    this.data.deleteFiles();
                    throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
                }
            } else {
                this.fileChannel.write(buffer);
            }
        }

        @Override
        public void endPart() {
            if (this.file != null) {
                this.data.add(this.currentName, this.file, this.fileName, this.headers);
                this.file = null;
                this.contentBytes.reset();
                try {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else if (this.fileName != null) {
                this.data.add(this.currentName, Arrays.copyOf(this.contentBytes.toByteArray(), this.contentBytes.size()), this.fileName, this.headers);
                this.contentBytes.reset();
            } else {
                String contentType = (String)this.headers.getFirst((Object)"Content-Type");
                if (this.isText(contentType)) {
                    try {
                        String cs;
                        String charset = this.defaultEncoding;
                        String string = cs = contentType != null ? HeaderUtil.extractQuotedValueFromHeader((String)contentType, (String)"charset") : null;
                        if (cs != null) {
                            charset = cs;
                        }
                        this.data.add(this.currentName, this.contentBytes.toString(charset), charset, this.headers);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.data.add(this.currentName, Arrays.copyOf(this.contentBytes.toByteArray(), this.contentBytes.size()), null, this.headers);
                }
                this.contentBytes.reset();
            }
        }

        private boolean isText(String contentType) {
            if (contentType == null || contentType.isEmpty()) {
                return true;
            }
            return MediaTypeHelper.isTextLike((MediaType)MediaType.valueOf((String)contentType));
        }

        public List<Path> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public void close() throws IOException {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
            if (MultiPartParserDefinition.this.deleteUploadsOnEnd) {
                this.deleteFiles();
            }
        }

        private void deleteFiles() {
            final ArrayList<Path> files = new ArrayList<Path>(this.getCreatedFiles());
            MultiPartParserDefinition.this.executorSupplier.get().execute(new Runnable(){

                @Override
                public void run() {
                    for (Path file : files) {
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        try {
                            Files.delete(file);
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                        catch (IOException e) {
                            log.error((Object)("Cannot remove uploaded file " + file), (Throwable)e);
                        }
                    }
                }
            });
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.defaultEncoding = encoding;
            this.parser.setCharacterEncoding(encoding);
        }

        private final class NonBlockingParseTask
        implements ServerHttpRequest.ReadCallback {
            private final Executor executor;

            private NonBlockingParseTask(Executor executor) {
                this.executor = executor;
            }

            @Override
            public void done() {
                if (MultiPartUploadHandler.this.parser.isComplete()) {
                    MultiPartUploadHandler.this.exchange.setFormData(MultiPartUploadHandler.this.data);
                    MultiPartUploadHandler.this.exchange.resume();
                } else {
                    MultiPartUploadHandler.this.exchange.resume(new IOException("Connection terminated reading multipart data"));
                }
            }

            @Override
            public void data(final ByteBuffer data) {
                MultiPartUploadHandler.this.exchange.serverRequest().pauseRequestInput();
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MultiPartUploadHandler.this.parser.parse(data);
                            MultiPartUploadHandler.this.exchange.serverRequest().resumeRequestInput();
                        }
                        catch (Throwable t) {
                            MultiPartUploadHandler.this.exchange.resume(t);
                        }
                    }
                });
            }
        }
    }

    public static class FileTooLargeException
    extends IOException {
        public FileTooLargeException() {
        }

        public FileTooLargeException(String message) {
            super(message);
        }

        public FileTooLargeException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileTooLargeException(Throwable cause) {
            super(cause);
        }
    }
}

