/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class LazyValue<T> {
    private final Supplier<T> supplier;
    private final Lock lock = new ReentrantLock();
    private volatile transient T value;

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() {
        T valueCopy = this.value;
        if (valueCopy != null) {
            return valueCopy;
        }
        this.lock.lock();
        try {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            T t = this.value;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T getIfPresent() {
        return this.value;
    }

    public void clear() {
        this.lock.lock();
        this.value = null;
        this.lock.unlock();
    }

    public boolean isSet() {
        return this.value != null;
    }
}

