/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteNamedCache;

public class BackupConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<BackupConfiguration> {
    private final AttributeSet attributes = BackupConfiguration.attributeDefinitionSet();
    private final XSiteStateTransferConfigurationBuilder stateTransferBuilder;
    private final TakeOfflineConfigurationBuilder takeOfflineBuilder;

    public BackupConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.takeOfflineBuilder = new TakeOfflineConfigurationBuilder(builder, this);
        this.stateTransferBuilder = new XSiteStateTransferConfigurationBuilder(builder, this);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public BackupConfigurationBuilder site(String site) {
        this.attributes.attribute(BackupConfiguration.SITE).set((Object)XSiteNamedCache.cachedString(site));
        return this;
    }

    public String site() {
        return (String)this.attributes.attribute(BackupConfiguration.SITE).get();
    }

    public String failurePolicyClass() {
        return (String)this.attributes.attribute(BackupConfiguration.FAILURE_POLICY_CLASS).get();
    }

    public BackupConfigurationBuilder failurePolicyClass(String failurePolicy) {
        this.attributes.attribute(BackupConfiguration.FAILURE_POLICY_CLASS).set((Object)failurePolicy);
        return this;
    }

    public BackupConfigurationBuilder replicationTimeout(long replicationTimeout) {
        this.attributes.attribute(BackupConfiguration.REPLICATION_TIMEOUT).set((Object)replicationTimeout);
        return this;
    }

    public BackupConfigurationBuilder strategy(BackupConfiguration.BackupStrategy strategy) {
        this.attributes.attribute(BackupConfiguration.STRATEGY).set((Object)strategy);
        return this;
    }

    public BackupConfiguration.BackupStrategy strategy() {
        return (BackupConfiguration.BackupStrategy)((Object)this.attributes.attribute(BackupConfiguration.STRATEGY).get());
    }

    public TakeOfflineConfigurationBuilder takeOffline() {
        return this.takeOfflineBuilder;
    }

    public BackupConfigurationBuilder backupFailurePolicy(BackupFailurePolicy backupFailurePolicy) {
        this.attributes.attribute(BackupConfiguration.FAILURE_POLICY).set((Object)backupFailurePolicy);
        return this;
    }

    public BackupConfigurationBuilder useTwoPhaseCommit(boolean useTwoPhaseCommit) {
        this.attributes.attribute(BackupConfiguration.USE_TWO_PHASE_COMMIT).set((Object)useTwoPhaseCommit);
        return this;
    }

    @Deprecated(forRemoval=true)
    public BackupConfigurationBuilder enabled(boolean isEnabled) {
        return this;
    }

    public XSiteStateTransferConfigurationBuilder stateTransfer() {
        return this.stateTransferBuilder;
    }

    public void validate() {
        this.takeOfflineBuilder.validate();
        this.stateTransferBuilder.validate();
        String siteName = (String)this.attributes.attribute(BackupConfiguration.SITE).get();
        if (siteName == null) {
            throw Log.CONFIG.backupMissingSite();
        }
        BackupFailurePolicy policy = (BackupFailurePolicy)((Object)this.attributes.attribute(BackupConfiguration.FAILURE_POLICY).get());
        boolean asyncStrategy = this.strategy() == BackupConfiguration.BackupStrategy.ASYNC;
        boolean hasFailurePolicyClass = this.failurePolicyClass() != null;
        switch (policy) {
            case CUSTOM: {
                if (!hasFailurePolicyClass) {
                    throw Log.CONFIG.missingBackupFailurePolicyClass(siteName);
                }
                if (!asyncStrategy) break;
                throw Log.CONFIG.invalidPolicyWithAsyncStrategy(siteName, policy);
            }
            case WARN: 
            case IGNORE: {
                if (!hasFailurePolicyClass) break;
                throw Log.CONFIG.failurePolicyClassNotCompatibleWith(siteName, policy);
            }
            case FAIL: {
                if (hasFailurePolicyClass) {
                    throw Log.CONFIG.failurePolicyClassNotCompatibleWith(siteName, policy);
                }
                if (!asyncStrategy) break;
                throw Log.CONFIG.invalidPolicyWithAsyncStrategy(siteName, policy);
            }
            default: {
                throw new IllegalStateException("Unexpected backup policy " + String.valueOf((Object)policy) + " for backup " + siteName);
            }
        }
        if (((Boolean)this.attributes.attribute(BackupConfiguration.USE_TWO_PHASE_COMMIT).get()).booleanValue() && asyncStrategy) {
            throw Log.CONFIG.twoPhaseCommitAsyncBackup();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.takeOfflineBuilder.validate(globalConfig);
        this.stateTransferBuilder.validate(globalConfig);
    }

    public BackupConfiguration create() {
        return new BackupConfiguration(this.attributes.protect(), this.takeOfflineBuilder.create(), this.stateTransferBuilder.create());
    }

    public BackupConfigurationBuilder read(BackupConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.takeOfflineBuilder.read(template.takeOffline(), combine);
        this.stateTransferBuilder.read(template.stateTransfer(), combine);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.attributes);
    }
}

