/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;

final class NIOMarkerPacket
extends NIOPacket {
    private static final String CLASS_NAME = NIOMarkerPacket.class.getName();
    private boolean isReset;
    private boolean isBreak;
    private ByteBuffer markerBuffer;

    NIOMarkerPacket(SessionAtts session) {
        super(session);
        this.header.type = 12;
        this.markerBuffer = ByteBuffer.allocate(11);
    }

    NIOMarkerPacket(NIOHeader header, SessionAtts session) throws IOException {
        super(header, session);
        header.type = 12;
    }

    void writeToSocketChannel(int type, byte markerData) throws IOException {
        this.markerBuffer.clear();
        if (this.session.isLargeSDU) {
            this.markerBuffer.putInt(this.markerBuffer.capacity());
        } else {
            this.markerBuffer.putShort((short)this.markerBuffer.capacity());
            this.markerBuffer.putShort((short)0);
        }
        this.markerBuffer.put((byte)this.header.type);
        this.markerBuffer.put((byte)this.header.flags);
        this.markerBuffer.putShort((short)0);
        this.markerBuffer.put((byte)type);
        this.markerBuffer.put((byte)0);
        this.markerBuffer.put(markerData);
        this.markerBuffer.limit(this.markerBuffer.position());
        this.markerBuffer.rewind();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeToSocketChannel", "Type = {0}, Length = {1}, flags = {2}, MarkerBuffer = {3}, SessionTraceID = {4}", (String)null, null, (Object)this.header.type, (Object)this.header.length, (Object)this.header.flags, (Object)this.markerBuffer, (Object)this.session.traceId);
        if (this.session.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
            ((MQLNTAdapter)this.session.nt).writeToRemoteQueue(this.markerBuffer, false);
        } else {
            while (this.markerBuffer.hasRemaining()) {
                this.session.socketChannel.write(this.markerBuffer);
            }
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        byte mktype = this.session.payloadBufferForRead.get();
        byte mkodt = this.session.payloadBufferForRead.get();
        switch (mktype) {
            case 0: {
                this.isBreak = true;
                break;
            }
            case 1: {
                byte mkdat = this.session.payloadBufferForRead.get();
                if (mkdat == 2) {
                    this.isBreak = false;
                    this.isReset = true;
                    break;
                }
                this.isReset = false;
                this.isBreak = true;
                break;
            }
            default: {
                throw new NetException(17905);
            }
        }
    }

    boolean isBreakPkt() {
        return this.isBreak;
    }

    boolean isResetPkt() {
        return this.isReset;
    }
}

