/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.client.clienttype.ClientTypeManager;
import org.keycloak.client.clienttype.ClientTypeManagerFactory;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.representations.idm.ClientTypesRepresentation;
import org.keycloak.services.clienttype.DefaultClientTypeManager;
import org.keycloak.util.JsonSerialization;

public class DefaultClientTypeManagerFactory
implements ClientTypeManagerFactory {
    private static final Logger logger = Logger.getLogger(DefaultClientTypeManagerFactory.class);
    private volatile List<ClientTypeRepresentation> globalClientTypes;

    public ClientTypeManager create(KeycloakSession session) {
        return new DefaultClientTypeManager(session, this.getGlobalClientTypes(session));
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ClientTypeRepresentation> getGlobalClientTypes(KeycloakSession session) {
        if (this.globalClientTypes == null) {
            DefaultClientTypeManagerFactory defaultClientTypeManagerFactory = this;
            synchronized (defaultClientTypeManagerFactory) {
                if (this.globalClientTypes == null) {
                    logger.info((Object)"Loading global client types");
                    try {
                        ClientTypesRepresentation globalTypesRep = (ClientTypesRepresentation)JsonSerialization.readValue((InputStream)this.getClass().getResourceAsStream("/keycloak-default-client-types.json"), ClientTypesRepresentation.class);
                        this.globalClientTypes = DefaultClientTypeManager.validateAndCastConfiguration(session, globalTypesRep.getRealmClientTypes(), Collections.emptyList());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to deserialize global proposed client types from JSON.", e);
                    }
                }
            }
        }
        return this.globalClientTypes;
    }
}

