/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.services.managers.AuthSessionId;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;

public class UserSessionCrossDCManager {
    private static final Logger logger = Logger.getLogger(UserSessionCrossDCManager.class);
    private final KeycloakSession kcSession;

    public UserSessionCrossDCManager(KeycloakSession session) {
        this.kcSession = session;
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, boolean offline, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, offline, userSession -> userSession.getAuthenticatedClientSessionByClient(clientUUID) != null);
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, false, userSession -> {
            AuthenticatedClientSessionModel authSessions = userSession.getAuthenticatedClientSessionByClient(clientUUID);
            return authSessions != null;
        });
    }

    public UserSessionModel getUserSessionIfExistsRemotely(AuthenticationSessionManager asm, RealmModel realm) {
        String oldEncodedId = asm.getAuthSessionCookies(realm);
        if (oldEncodedId == null) {
            AuthenticationManager.AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(this.kcSession, realm, true);
            if (authResult != null && authResult.getSession() != null) {
                oldEncodedId = authResult.getSession().getId();
            } else {
                return null;
            }
        }
        AuthSessionId authSessionId = asm.decodeAuthSessionId(oldEncodedId);
        String sessionId = authSessionId.getDecodedId();
        this.kcSession.sessions().getUserSessionWithPredicate(realm, sessionId, false, userSession2 -> userSession2 == null);
        UserSessionModel userSession = this.kcSession.sessions().getUserSession(realm, sessionId);
        if (userSession != null) {
            asm.reencodeAuthSessionCookie(oldEncodedId, authSessionId, realm);
            return userSession;
        }
        return null;
    }
}

