/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingNames;
import io.smallrye.config.ConfigMappingProvider;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SmallRyeConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class ConfigMappings
implements Serializable {
    private static final long serialVersionUID = -7790784345796818526L;

    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            Boolean validateUnknown = config.getOptionalValue("smallrye.config.mapping.validate-unknown", Boolean.class).orElse(Boolean.TRUE);
            ConfigMappings.mapConfiguration(config, ConfigMappingProvider.builder().validateUnknown(validateUnknown), configClasses);
        }
    }

    public static void registerConfigProperties(SmallRyeConfig config, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, ConfigMappingProvider.builder().validateUnknown(false), configClasses);
        }
    }

    public static Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> getProperties(final ConfigClassWithPrefix configClass) {
        HashMap properties = new HashMap();
        Function<String, String> path = new Function<String, String>(){

            @Override
            public String apply(String path) {
                return configClass.getPrefix().isEmpty() && !path.isEmpty() ? path.substring(1) : configClass.getPrefix() + path;
            }
        };
        ConfigMappingInterface configMapping = ConfigMappingLoader.getConfigMapping(configClass.getKlass());
        ConfigMappings.getProperties(new ConfigMappingInterface.GroupProperty(null, null, configMapping), configMapping.getNamingStrategy(), path, properties);
        return properties;
    }

    public static Map<String, Map<String, Set<String>>> getNames(ConfigClassWithPrefix configClass) {
        HashMap<String, Map<String, Set<String>>> names = new HashMap<String, Map<String, Set<String>>>();
        Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> properties = ConfigMappings.getProperties(configClass);
        for (Map.Entry<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> entry : properties.entrySet()) {
            HashMap<String, Set<String>> groups = new HashMap<String, Set<String>>();
            for (Map.Entry<String, Map<String, ConfigMappingInterface.Property>> group : entry.getValue().entrySet()) {
                groups.put(group.getKey(), group.getValue().keySet());
            }
            names.put(entry.getKey().getName(), groups);
        }
        return names;
    }

    public static Set<String> getKeys(ConfigClassWithPrefix configClass) {
        return ConfigMappings.getProperties(configClass).get(configClass.getKlass()).get(configClass.getPrefix()).keySet();
    }

    public static Map<String, String> getDefaults(ConfigClassWithPrefix configClass) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> properties = ConfigMappings.getProperties(configClass);
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : properties.get(configClass.getKlass()).get(configClass.getPrefix()).entrySet()) {
            if (!entry.getValue().hasDefaultValue()) continue;
            defaults.put(entry.getKey(), entry.getValue().getDefaultValue());
        }
        return defaults;
    }

    public static Set<String> mappedProperties(ConfigClassWithPrefix configClass, Set<String> properties) {
        Set<PropertyName> names = new ConfigMappingNames(ConfigMappings.getNames(configClass)).get(configClass.getKlass().getName(), configClass.getPrefix());
        HashSet<String> mappedProperties = new HashSet<String>();
        for (String property : properties) {
            if (!names.contains(new PropertyName(property))) continue;
            mappedProperties.add(property);
        }
        return mappedProperties;
    }

    private static void mapConfiguration(SmallRyeConfig config, ConfigMappingProvider.Builder builder, Set<ConfigClassWithPrefix> configClasses) throws ConfigValidationException {
        DefaultValuesConfigSource defaultValues = (DefaultValuesConfigSource)config.getDefaultValues();
        for (ConfigClassWithPrefix configClass : configClasses) {
            builder.addRoot(configClass.getPrefix(), configClass.getKlass());
            defaultValues.addDefaults(ConfigMappings.getDefaults(ConfigClassWithPrefix.configClassWithPrefix(ConfigMappingLoader.getConfigMappingClass(configClass.getKlass()), configClass.getPrefix())));
        }
        config.getMappings().putAll(builder.build().mapConfiguration(config));
    }

    private static void getProperties(ConfigMappingInterface.GroupProperty groupProperty, ConfigMapping.NamingStrategy namingStrategy, Function<String, String> path, Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> properties) {
        ConfigMappingInterface groupType = groupProperty.getGroupType();
        Map groupProperties = properties.computeIfAbsent(groupType.getInterfaceType(), group -> new HashMap()).computeIfAbsent(path.apply(""), s -> new HashMap());
        ConfigMappings.getProperties(groupProperty, namingStrategy, path, properties, groupProperties);
    }

    private static void getProperties(ConfigMappingInterface.GroupProperty groupProperty, ConfigMapping.NamingStrategy namingStrategy, Function<String, String> path, Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> properties, Map<String, ConfigMappingInterface.Property> groupProperties) {
        for (ConfigMappingInterface.Property property : groupProperty.getGroupType().getProperties(true)) {
            ConfigMappings.getProperty(property, namingStrategy, path, properties, groupProperties);
        }
    }

    private static void getProperty(final ConfigMappingInterface.Property property, final ConfigMapping.NamingStrategy namingStrategy, final Function<String, String> path, Map<Class<?>, Map<String, Map<String, ConfigMappingInterface.Property>>> properties, Map<String, ConfigMappingInterface.Property> groupProperties) {
        if (property.isLeaf()) {
            groupProperties.put(path.apply((String)(property.isParentPropertyName() ? "" : "." + property.getPropertyName(namingStrategy))), property);
        } else if (property.isPrimitive()) {
            groupProperties.put(path.apply((String)(property.isParentPropertyName() ? "" : "." + property.getPropertyName(namingStrategy))), property);
        } else if (property.isGroup()) {
            ConfigMappingInterface.GroupProperty groupProperty = property.asGroup();
            ConfigMapping.NamingStrategy groupNamingStrategy = groupProperty.hasNamingStrategy() ? groupProperty.getNamingStrategy() : namingStrategy;
            Function<String, String> groupPath = new Function<String, String>(){

                @Override
                public String apply(String name) {
                    return property.isParentPropertyName() ? (String)path.apply("") + name : (String)path.apply("." + property.getPropertyName(namingStrategy)) + name;
                }
            };
            ConfigMappings.getProperties(groupProperty, groupNamingStrategy, groupPath, properties);
            ConfigMappings.getProperties(groupProperty, groupNamingStrategy, groupPath, properties, groupProperties);
        } else if (property.isMap()) {
            final ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            if (mapProperty.getValueProperty().isLeaf()) {
                groupProperties.put(property.isParentPropertyName() ? path.apply(".*") : path.apply("." + property.getPropertyName(namingStrategy) + ".*"), mapProperty);
                if (mapProperty.hasKeyUnnamed()) {
                    groupProperties.put(property.isParentPropertyName() ? path.apply("") : path.apply("." + property.getPropertyName(namingStrategy)), mapProperty);
                }
            } else if (mapProperty.getValueProperty().isGroup()) {
                ConfigMappingInterface.GroupProperty groupProperty = mapProperty.getValueProperty().asGroup();
                ConfigMapping.NamingStrategy groupNamingStrategy = groupProperty.hasNamingStrategy() ? groupProperty.getNamingStrategy() : namingStrategy;
                Function<String, String> groupPath = new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        return property.isParentPropertyName() ? (String)path.apply(".*") + name : (String)path.apply("." + mapProperty.getPropertyName(namingStrategy) + ".*") + name;
                    }
                };
                ConfigMappings.getProperties(groupProperty, groupNamingStrategy, groupPath, properties);
                ConfigMappings.getProperties(groupProperty, groupNamingStrategy, groupPath, properties, groupProperties);
                if (mapProperty.hasKeyUnnamed()) {
                    Function<String, String> unnamedGroupPath = new Function<String, String>(){

                        @Override
                        public String apply(String name) {
                            return property.isParentPropertyName() ? (String)path.apply(name) : (String)path.apply("." + mapProperty.getPropertyName(namingStrategy)) + name;
                        }
                    };
                    ConfigMappings.getProperties(groupProperty, groupNamingStrategy, unnamedGroupPath, properties);
                    ConfigMappings.getProperties(groupProperty, groupNamingStrategy, unnamedGroupPath, properties, groupProperties);
                }
            } else if (mapProperty.getValueProperty().isCollection()) {
                ConfigMappingInterface.CollectionProperty collectionProperty = mapProperty.getValueProperty().asCollection();
                ConfigMappingInterface.Property element = collectionProperty.getElement();
                if (element.isLeaf()) {
                    ConfigMappingInterface.LeafProperty leafProperty = new ConfigMappingInterface.LeafProperty(element.getMethod(), element.getPropertyName(), element.asLeaf().getValueType(), element.asLeaf().getConvertWith(), null);
                    ConfigMappings.getProperty(leafProperty, namingStrategy, new Function<String, String>(){

                        @Override
                        public String apply(String name) {
                            return (String)path.apply(name + ".*");
                        }
                    }, properties, groupProperties);
                }
                ConfigMappings.getProperty(element, namingStrategy, new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        return (String)path.apply(name + ".*[*]");
                    }
                }, properties, groupProperties);
                if (mapProperty.hasKeyUnnamed()) {
                    ConfigMappings.getProperty(element, namingStrategy, new Function<String, String>(){

                        @Override
                        public String apply(String name) {
                            return (String)path.apply(name + "[*]");
                        }
                    }, properties, groupProperties);
                }
            } else if (mapProperty.getValueProperty().isMap()) {
                ConfigMappings.getProperty(mapProperty.getValueProperty(), namingStrategy, new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        return (String)path.apply(name + ".*");
                    }
                }, properties, groupProperties);
                if (mapProperty.hasKeyUnnamed()) {
                    ConfigMappings.getProperty(mapProperty.getValueProperty(), namingStrategy, new Function<String, String>(){

                        @Override
                        public String apply(String name) {
                            return (String)path.apply(name);
                        }
                    }, properties, groupProperties);
                }
            }
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            if (collectionProperty.getElement().isLeaf()) {
                ConfigMappings.getProperty(collectionProperty.getElement(), namingStrategy, path, properties, groupProperties);
            }
            ConfigMappings.getProperty(collectionProperty.getElement(), namingStrategy, new Function<String, String>(){

                @Override
                public String apply(String name) {
                    return (String)path.apply(name.endsWith(".*") ? name.substring(0, name.length() - 2) + "[*].*" : name + "[*]");
                }
            }, properties, groupProperties);
        } else if (property.isOptional()) {
            ConfigMappings.getProperty(property.asOptional().getNestedProperty(), namingStrategy, path, properties, groupProperties);
        }
    }

    static String getPrefix(Class<?> type) {
        ConfigMapping configMapping = type.getAnnotation(ConfigMapping.class);
        return configMapping != null ? configMapping.prefix() : "";
    }

    public static final class ConfigClassWithPrefix {
        private final Class<?> klass;
        private final String prefix;

        public ConfigClassWithPrefix(Class<?> klass, String prefix) {
            this.klass = klass;
            this.prefix = prefix;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigClassWithPrefix that = (ConfigClassWithPrefix)o;
            return this.klass.equals(that.klass) && this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.klass, this.prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass, String prefix) {
            return new ConfigClassWithPrefix(klass, prefix);
        }

        public static ConfigClassWithPrefix configClassWithPrefix(Class<?> klass) {
            return ConfigClassWithPrefix.configClassWithPrefix(klass, ConfigMappings.getPrefix(klass));
        }
    }
}

