/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.GroupQuery;

public class GroupListQuery
extends AbstractRevisioned
implements GroupQuery {
    private final String realm;
    private final String realmName;
    private Map<String, Set<String>> searchKeys;

    public GroupListQuery(Long revisioned, String id, RealmModel realm, String searchKey, Set<String> result) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.searchKeys = new HashMap<String, Set<String>>();
        this.searchKeys.put(searchKey, result);
    }

    public GroupListQuery(Long revisioned, String id, RealmModel realm, String searchKey, Set<String> result, GroupListQuery previous) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.searchKeys = new HashMap<String, Set<String>>();
        this.searchKeys.putAll(previous.searchKeys);
        this.searchKeys.put(searchKey, result);
    }

    public GroupListQuery(Long revisioned, String id, RealmModel realm, Set<String> ids) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.searchKeys = new HashMap<String, Set<String>>();
        this.searchKeys.put(id, ids);
    }

    @Override
    public Set<String> getGroups() {
        Collection<Set<String>> values = this.searchKeys.values();
        if (values.isEmpty()) {
            return Set.of();
        }
        return values.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getGroups(String searchKey) {
        return this.searchKeys.get(searchKey);
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public Map<String, Set<String>> getSearchKeys() {
        if (this.searchKeys == null) {
            this.searchKeys = new HashMap<String, Set<String>>();
        }
        return this.searchKeys;
    }

    public String toString() {
        return "GroupListQuery{id='" + this.getId() + "'realmName='" + this.realmName + "'}";
    }
}

