/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorBuildItem;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorCandidateBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpSecurityPolicyBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.VertxBlockingSecurityExecutor;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientAuth;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class HttpSecurityProcessor {
    private static final DotName BASIC_AUTH_MECH_NAME = DotName.createSimple(BasicAuthenticationMechanism.class);

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void produceNamedHttpSecurityPolicies(List<HttpSecurityPolicyBuildItem> httpSecurityPolicyBuildItems, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, HttpSecurityRecorder recorder) {
        if (!httpSecurityPolicyBuildItems.isEmpty()) {
            httpSecurityPolicyBuildItems.forEach(item -> syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(HttpSecurityPolicy.class).named(HttpSecurityPolicy.class.getName() + "." + item.getName())).runtimeValue(recorder.createNamedHttpSecurityPolicy(item.getPolicySupplier(), item.getName())).addType(HttpSecurityPolicy.class)).scope(Singleton.class)).unremovable()).done()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    AdditionalBeanBuildItem initFormAuth(HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig, BuildProducer<RouteBuildItem> filterBuildItemBuildProducer) {
        if (buildTimeConfig.auth.form.enabled) {
            if (!buildTimeConfig.auth.proactive) {
                filterBuildItemBuildProducer.produce((BuildItem)RouteBuildItem.builder().route(buildTimeConfig.auth.form.postLocation).handler((Handler<RoutingContext>)recorder.formAuthPostHandler()).build());
            }
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(FormAuthenticationMechanism.class).setDefaultScope(DotNames.SINGLETON).build();
        }
        return null;
    }

    @BuildStep
    AdditionalBeanBuildItem initMtlsClientAuth(HttpBuildTimeConfig buildTimeConfig) {
        if (HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig)) {
            return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(MtlsAuthenticationMechanism.class).setDefaultScope(DotNames.SINGLETON).build();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setMtlsCertificateRoleProperties(HttpSecurityRecorder recorder, HttpConfiguration config, HttpBuildTimeConfig buildTimeConfig) {
        if (HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig)) {
            recorder.setMtlsCertificateRoleProperties(config);
        }
    }

    @BuildStep(onlyIf={IsApplicationBasicAuthRequired.class})
    AdditionalBeanBuildItem initBasicAuth(HttpBuildTimeConfig buildTimeConfig, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformerProducer, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        if (!(buildTimeConfig.auth.form.enabled || HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig) || buildTimeConfig.auth.basic.orElse(false).booleanValue())) {
            annotationsTransformerProducer.produce((BuildItem)new AnnotationsTransformerBuildItem(AnnotationsTransformer.appliedToClass().whenClass(cl -> BASIC_AUTH_MECH_NAME.equals((Object)cl.name())).thenTransform(t -> t.add(DotNames.DEFAULT_BEAN, new AnnotationValue[0]))));
        }
        if (buildTimeConfig.auth.basic.isPresent() && ((Boolean)buildTimeConfig.auth.basic.get()).booleanValue()) {
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(BasicAuthenticationMechanism.class).build();
    }

    public static boolean applicationBasicAuthRequired(HttpBuildTimeConfig buildTimeConfig, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (buildTimeConfig.auth.basic.isPresent() && !((Boolean)buildTimeConfig.auth.basic.get()).booleanValue()) {
            return false;
        }
        return buildTimeConfig.auth.basic.orElse(false) != false || !buildTimeConfig.auth.form.enabled && !HttpSecurityProcessor.isMtlsClientAuthenticationEnabled(buildTimeConfig) && managementInterfaceBuildTimeConfig.auth.basic.orElse(false) == false;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(HttpSecurityRecorder recorder, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Capabilities capabilities, HttpBuildTimeConfig buildTimeConfig, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        if (!buildTimeConfig.auth.form.enabled && buildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        if (capabilities.isPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(VertxBlockingSecurityExecutor.class).setDefaultScope(DotNames.APPLICATION_SCOPED).build());
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(HttpAuthorizer.class).build());
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PathMatchingHttpSecurityPolicy.class));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.authenticationMechanismHandler(buildTimeConfig.auth.proactive), 200));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), 100));
        }
    }

    @BuildStep
    void collectEagerSecurityInterceptors(List<EagerSecurityInterceptorCandidateBuildItem> interceptorCandidates, HttpBuildTimeConfig buildTimeConfig, Capabilities capabilities, BuildProducer<EagerSecurityInterceptorBuildItem> interceptorsProducer) {
        if (!buildTimeConfig.auth.proactive && capabilities.isPresent("io.quarkus.security") && !interceptorCandidates.isEmpty()) {
            List<MethodInfo> allInterceptedMethodInfos = interceptorCandidates.stream().map(EagerSecurityInterceptorCandidateBuildItem::getMethodInfo).collect(Collectors.toList());
            Map<RuntimeValue<MethodDescription>, Consumer<RoutingContext>> methodToInterceptor = interceptorCandidates.stream().collect(Collectors.toMap(EagerSecurityInterceptorCandidateBuildItem::getDescriptionRuntimeValue, EagerSecurityInterceptorCandidateBuildItem::getSecurityInterceptor));
            interceptorsProducer.produce((BuildItem)new EagerSecurityInterceptorBuildItem(allInterceptedMethodInfos, methodToInterceptor));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void produceEagerSecurityInterceptorStorage(HttpSecurityRecorder recorder, BuildProducer<SyntheticBeanBuildItem> producer, Optional<EagerSecurityInterceptorBuildItem> interceptors) {
        if (interceptors.isPresent()) {
            producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(EagerSecurityInterceptorStorage.class).scope(ApplicationScoped.class)).supplier(recorder.createSecurityInterceptorStorage(interceptors.get().methodCandidateToSecurityInterceptor)).unremovable()).done());
        }
    }

    private static boolean isMtlsClientAuthenticationEnabled(HttpBuildTimeConfig buildTimeConfig) {
        return !ClientAuth.NONE.equals((Object)buildTimeConfig.tlsClientAuth);
    }

    static class IsApplicationBasicAuthRequired
    implements BooleanSupplier {
        private final boolean required;

        public IsApplicationBasicAuthRequired(HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
            this.required = HttpSecurityProcessor.applicationBasicAuthRequired(httpBuildTimeConfig, managementInterfaceBuildTimeConfig);
        }

        @Override
        public boolean getAsBoolean() {
            return this.required;
        }
    }
}

