/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc.json;

import io.quarkus.dev.console.DeploymentLinker;
import io.quarkus.devui.runtime.jsonrpc.json.JsonTypeAdapter;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface JsonMapper {
    public String toString(Object var1, boolean var2);

    public <T> T fromString(String var1, Class<T> var2);

    public <T> T fromValue(Object var1, Class<T> var2);

    public static DeploymentLinker<JsonMapper> deploymentLinker() {
        return new DeploymentLinker<JsonMapper>(){

            public Map<String, ?> createLinkData(JsonMapper object) {
                return Map.of("delegate", object, "toString", object::toString, "fromString", object::fromString, "fromValue", object::fromValue);
            }

            public JsonMapper createLink(Map<String, ?> linkData) {
                final Object delegate = linkData.get("delegate");
                final BiFunction toString = (BiFunction)linkData.get("toString");
                final BiFunction fromString = (BiFunction)linkData.get("fromString");
                final BiFunction fromValue = (BiFunction)linkData.get("fromValue");
                return new JsonMapper(){

                    public String toString() {
                        return "JsonMapper[delegate=" + delegate + "]";
                    }

                    @Override
                    public String toString(Object object, boolean pretty) {
                        return (String)toString.apply(object, pretty);
                    }

                    @Override
                    public <T> T fromString(String json, Class<T> target) {
                        return target.cast(fromString.apply(json, target));
                    }

                    @Override
                    public <T> T fromValue(Object json, Class<T> target) {
                        if (target.isPrimitive()) {
                            return (T)json;
                        }
                        return target.cast(fromValue.apply(json, target));
                    }
                };
            }
        };
    }

    public static interface Factory {
        public JsonMapper create(JsonTypeAdapter<?, Map<String, Object>> var1, JsonTypeAdapter<?, List<?>> var2, JsonTypeAdapter<?, String> var3);

        public static DeploymentLinker<Factory> deploymentLinker() {
            return new DeploymentLinker<Factory>(){

                public Map<String, ?> createLinkData(Factory object) {
                    return Map.of("delegate", object, "create", args -> {
                        JsonMapper created = object.create(this.typeAdapterFromLinkData(args.get("jsonObjectAdapter")), this.typeAdapterFromLinkData(args.get("jsonArrayAdapter")), this.typeAdapterFromLinkData(args.get("bufferAdapter")));
                        return JsonMapper.deploymentLinker().createLinkData((Object)created);
                    });
                }

                public Factory createLink(Map<String, ?> linkData) {
                    final Object delegate = linkData.get("delegate");
                    final Function create = (Function)linkData.get("create");
                    return new Factory(){

                        public String toString() {
                            return "JsonMapper[delegate=" + delegate + "]";
                        }

                        @Override
                        public JsonMapper create(JsonTypeAdapter<?, Map<String, Object>> jsonObjectAdapter, JsonTypeAdapter<?, List<?>> jsonArrayAdapter, JsonTypeAdapter<?, String> bufferAdapter) {
                            Map linkData = (Map)create.apply(Map.of("jsonObjectAdapter", this.typeAdapterToLinkData(jsonObjectAdapter), "jsonArrayAdapter", this.typeAdapterToLinkData(jsonArrayAdapter), "bufferAdapter", this.typeAdapterToLinkData(bufferAdapter)));
                            return (JsonMapper)JsonMapper.deploymentLinker().createLink(linkData);
                        }
                    };
                }

                private Map<String, ?> typeAdapterToLinkData(JsonTypeAdapter<?, ?> object) {
                    return Map.of("type", object.type, "serializer", object.serializer, "deserializer", object.deserializer);
                }

                private <T, S> JsonTypeAdapter<T, S> typeAdapterFromLinkData(Object linkData) {
                    Map map = (Map)linkData;
                    return new JsonTypeAdapter((Class)map.get("type"), (Function)map.get("serializer"), (Function)map.get("deserializer"));
                }
            };
        }
    }
}

