/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class ExchangeDataAttribute
implements ExchangeAttribute {
    private final String dataKey;

    public ExchangeDataAttribute(String dataKey) {
        this.dataKey = dataKey;
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return (String)exchange.get(this.dataKey);
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException();
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Exchange data";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{d,") && token.endsWith("}")) {
                String dataItemName = token.substring(4, token.length() - 1);
                return new ExchangeDataAttribute(dataItemName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

