/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx.lookup;

import jakarta.transaction.TransactionManager;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;

public final class LookupNames {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    private LookupNames() {
    }

    public static Optional<TransactionManager> lookupKnownTransactionManagers(ClassLoader classLoader) {
        return LookupNames.lookupByJNDI().or(() -> LookupNames.lookupByTransactionManagerFactory(classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<TransactionManager> lookupByJNDI() {
        InitialContext ctx;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            Log.CONTAINER.failedToCreateInitialCtx(e);
            return Optional.empty();
        }
        try {
            for (JndiTransactionManager lookup : JndiTransactionManager.values()) {
                Object jndiObject;
                try {
                    log.debugf("Trying to lookup TransactionManager for %s", lookup.getPrettyName());
                    jndiObject = ctx.lookup(lookup.getJndiLookup());
                }
                catch (NamingException e) {
                    log.debugf("Failed to perform a lookup for [%s (%s)]", lookup.getJndiLookup(), lookup.getPrettyName());
                    continue;
                }
                if (!(jndiObject instanceof TransactionManager)) continue;
                log.debugf("Found TransactionManager for %s", lookup.getPrettyName());
                Optional<TransactionManager> optional = Optional.of((TransactionManager)jndiObject);
                return optional;
            }
        }
        finally {
            Util.close(ctx);
        }
        return Optional.empty();
    }

    public static Optional<TransactionManager> lookupByTransactionManagerFactory(ClassLoader classLoader) {
        for (TransactionManagerFactory factory : TransactionManagerFactory.values()) {
            log.debugf("Trying %s: %s", factory.getPrettyName(), factory.getFactoryClazz());
            TransactionManager transactionManager = factory.tryLookup(classLoader);
            if (transactionManager == null) continue;
            log.debugf("Found %s: %s", factory.getPrettyName(), factory.getFactoryClazz());
            return Optional.of(transactionManager);
        }
        return Optional.empty();
    }

    public static enum JndiTransactionManager {
        JBOSS_AS_7("java:jboss/TransactionManager", "JBoss AS 7"),
        JBOSS_AS_4_6("java:/TransactionManager", "JBoss AS 4 ~ 6, JRun4"),
        RESIN_3("java:comp/TransactionManager", "Resin 3.x"),
        GLASSFISH("java:appserver/TransactionManager", "Sun Glassfish"),
        BORLAND_SUN("java:pm/TransactionManager", "Borland, Sun"),
        WEBLOGIC("jakarta.transaction.TransactionManager", "BEA WebLogic"),
        RESIN_ORION_JONAS("java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)");

        private final String jndiLookup;
        private final String prettyName;

        private JndiTransactionManager(String jndiLookup, String prettyName) {
            this.jndiLookup = jndiLookup;
            this.prettyName = prettyName;
        }

        public String getJndiLookup() {
            return this.jndiLookup;
        }

        public String getPrettyName() {
            return this.prettyName;
        }
    }

    public static enum TransactionManagerFactory {
        WEBSPHERE_LIBERTY("com.ibm.tx.jta.TransactionManagerFactory", "WebSphere Liberty", "getTransactionManager"),
        WEBSPHERE_51_6("com.ibm.ws.Transaction.TransactionManagerFactory", "WebSphere 5.1 and 6.0", "getTransactionManager"),
        WEBSPHERE_6("com.ibm.ejs.jts.jta.TransactionManagerFactory", "WebSphere 5.0", "getTransactionManager"),
        WEBSPHERE_4("com.ibm.ejs.jts.jta.JTSXA", "WebSphere 4.0", "getTransactionManager"),
        WILDFLY("org.wildfly.transaction.client.ContextTransactionManager", "Wildfly 11 and later", "getInstance"),
        JBOSS_TM("com.arjuna.ats.jta.TransactionManager", "JBoss Standalone TM", "transactionManager");

        private final String factoryClazz;
        private final String prettyName;
        private final String factoryMethod;

        private TransactionManagerFactory(String factoryClazz, String prettyName, String factoryMethod) {
            this.factoryClazz = factoryClazz;
            this.prettyName = prettyName;
            this.factoryMethod = factoryMethod;
        }

        public String getFactoryClazz() {
            return this.factoryClazz;
        }

        public String getPrettyName() {
            return this.prettyName;
        }

        public TransactionManager tryLookup(ClassLoader classLoader) {
            try {
                Class clazz = Util.loadClassStrict(this.factoryClazz, classLoader);
                Method method = clazz.getMethod(this.factoryMethod, new Class[0]);
                return (TransactionManager)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
                return null;
            }
        }
    }
}

