/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;
import org.keycloak.config.SecurityOptions;

public class HttpOptions {
    public static final Option<Boolean> HTTP_ENABLED = new OptionBuilder<Boolean>("http-enabled", Boolean.class).category(OptionCategory.HTTP).description("Enables the HTTP listener.").defaultValue(Boolean.FALSE).build();
    public static final Option<String> HTTP_HOST = new OptionBuilder<String>("http-host", String.class).category(OptionCategory.HTTP).description("The used HTTP Host.").defaultValue("0.0.0.0").build();
    public static final Option<String> HTTP_RELATIVE_PATH = new OptionBuilder<String>("http-relative-path", String.class).category(OptionCategory.HTTP).description("Set the path relative to '/' for serving resources. The path must start with a '/'.").defaultValue("/").buildTime(true).build();
    public static final Option<Integer> HTTP_PORT = new OptionBuilder<Integer>("http-port", Integer.class).category(OptionCategory.HTTP).description("The used HTTP port.").defaultValue(8080).build();
    public static final Option<Integer> HTTPS_PORT = new OptionBuilder<Integer>("https-port", Integer.class).category(OptionCategory.HTTP).description("The used HTTPS port.").defaultValue(8443).build();
    public static final Option<ClientAuth> HTTPS_CLIENT_AUTH = new OptionBuilder<ClientAuth>("https-client-auth", ClientAuth.class).category(OptionCategory.HTTP).description("Configures the server to require/request client authentication.").defaultValue(ClientAuth.none).buildTime(true).build();
    public static final Option<String> HTTPS_CIPHER_SUITES = new OptionBuilder<String>("https-cipher-suites", String.class).category(OptionCategory.HTTP).description("The cipher suites to use. If none is given, a reasonable default is selected.").build();
    public static final Option<List<String>> HTTPS_PROTOCOLS = OptionBuilder.listOptionBuilder("https-protocols", String.class).category(OptionCategory.HTTP).description("The list of protocols to explicitly enable.").defaultValue(Arrays.asList("TLSv1.3,TLSv1.2")).build();
    public static final Option<File> HTTPS_CERTIFICATE_FILE = new OptionBuilder<File>("https-certificate-file", File.class).category(OptionCategory.HTTP).description("The file path to a server certificate or certificate chain in PEM format.").build();
    public static final Option<File> HTTPS_CERTIFICATE_KEY_FILE = new OptionBuilder<File>("https-certificate-key-file", File.class).category(OptionCategory.HTTP).description("The file path to a private key in PEM format.").build();
    public static final Option<File> HTTPS_KEY_STORE_FILE = new OptionBuilder<File>("https-key-store-file", File.class).category(OptionCategory.HTTP).description("The key store which holds the certificate information instead of specifying separate files.").build();
    public static final Option<String> HTTPS_KEY_STORE_PASSWORD = new OptionBuilder<String>("https-key-store-password", String.class).category(OptionCategory.HTTP).description("The password of the key store file.").defaultValue("password").build();
    public static final Option<String> HTTPS_KEY_STORE_TYPE = new OptionBuilder<String>("https-key-store-type", String.class).category(OptionCategory.HTTP).description("The type of the key store file. If not given, the type is automatically detected based on the file name. If '" + SecurityOptions.FIPS_MODE.getKey() + "' is set to '" + FipsMode.STRICT + "' and no value is set, it defaults to 'BCFKS'.").build();
    public static final Option<File> HTTPS_TRUST_STORE_FILE = new OptionBuilder<File>("https-trust-store-file", File.class).category(OptionCategory.HTTP).description("The trust store which holds the certificate information of the certificates to trust.").deprecated("Use the System Truststore instead, see the docs for details.").build();
    public static final Option<String> HTTPS_TRUST_STORE_PASSWORD = new OptionBuilder<String>("https-trust-store-password", String.class).category(OptionCategory.HTTP).description("The password of the trust store file.").deprecated("Use the System Truststore instead, see the docs for details.").build();
    public static final Option<String> HTTPS_TRUST_STORE_TYPE = new OptionBuilder<String>("https-trust-store-type", String.class).category(OptionCategory.HTTP).description("The type of the trust store file. If not given, the type is automatically detected based on the file name. If '" + SecurityOptions.FIPS_MODE.getKey() + "' is set to '" + FipsMode.STRICT + "' and no value is set, it defaults to 'BCFKS'.").deprecated("Use the System Truststore instead, see the docs for details.").build();
    public static final Option<Boolean> HTTP_SERVER_ENABLED = new OptionBuilder<Boolean>("http-server-enabled", Boolean.class).category(OptionCategory.HTTP).hidden().description("Enables or disables the HTTP/s and Socket serving.").defaultValue(Boolean.TRUE).build();
    public static final Option<Integer> HTTP_MAX_QUEUED_REQUESTS = new OptionBuilder<Integer>("http-max-queued-requests", Integer.class).category(OptionCategory.HTTP).description("Maximum number of queued HTTP requests. Use this to shed load in an overload situation. Excess requests will return a \"503 Server not Available\" response.").build();
    public static final Option<Integer> HTTP_POOL_MAX_THREADS = new OptionBuilder<Integer>("http-pool-max-threads", Integer.class).category(OptionCategory.HTTP).description("The maximum number of threads. If this is not specified then it will be automatically sized to the greatest of 8 * the number of available processors and 200. For example if there are 4 processors the max threads will be 200. If there are 48 processors it will be 384.").build();

    public static enum ClientAuth {
        none,
        request,
        required;

    }
}

