/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.cli.command.Start;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    public static void main(String[] args) {
        System.setProperty("kc.version", Version.VERSION);
        List<String> cliArgs = null;
        try {
            cliArgs = Picocli.parseArgs(args);
        }
        catch (PropertyException e) {
            ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
            PrintWriter errStream = new PrintWriter(System.err, true);
            errorHandler.error(errStream, e.getMessage(), null);
            System.exit(2);
            return;
        }
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (KeycloakMain.isFastStart(cliArgs)) {
            ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
            PrintWriter errStream = new PrintWriter(System.err, true);
            if (Start.isDevProfileNotAllowed()) {
                errorHandler.error(errStream, Messages.devProfileNotAllowedError("start"), null);
                System.exit(2);
                return;
            }
            try {
                Picocli.validateConfig(cliArgs, new Start());
            }
            catch (PropertyException e) {
                errorHandler.error(errStream, e.getMessage(), null);
                System.exit(2);
                return;
            }
            KeycloakMain.start(errorHandler, errStream, args);
            return;
        }
        Picocli.parseAndRun(cliArgs);
    }

    private static boolean isFastStart(List<String> cliArgs) {
        return cliArgs.size() == 2 && cliArgs.get(0).equals("start") && cliArgs.stream().anyMatch("--optimized"::equals);
    }

    public static void start(ExecutionExceptionHandler errorHandler, PrintWriter errStream, String[] args) {
        try {
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(errStream, String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause.getCause());
                }
                if (Environment.isDistribution()) {
                    System.exit(exitCode);
                }
            }, (String[])args);
        }
        catch (Throwable cause2) {
            errorHandler.error(errStream, String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause2.getCause());
            System.exit(1);
        }
    }

    public int run(String ... args) throws Exception {
        if (Environment.isDevProfile()) {
            Logger.getLogger(KeycloakMain.class).warnf("Running the server in development mode. DO NOT use this configuration in production.", new Object[0]);
        }
        int exitCode = ApplicationLifecycleManager.getExitCode();
        if (Environment.isTestLaunchMode() || Environment.isImportExportMode()) {
            Quarkus.asyncExit((int)exitCode);
        } else {
            Quarkus.waitForExit();
        }
        return exitCode;
    }
}

