/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.resteasy;

import io.vertx.core.http.HttpServerRequest;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Resteasy;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.quarkus.runtime.integration.resteasy.QuarkusClientConnection;
import org.keycloak.quarkus.runtime.integration.resteasy.QuarkusHttpRequest;
import org.keycloak.quarkus.runtime.integration.resteasy.QuarkusHttpResponse;
import org.keycloak.services.DefaultKeycloakContext;

public final class QuarkusKeycloakContext
extends DefaultKeycloakContext {
    private ClientConnection clientConnection;

    public QuarkusKeycloakContext(KeycloakSession session) {
        super(session);
    }

    protected HttpRequest createHttpRequest() {
        return new QuarkusHttpRequest(this.getResteasyReactiveRequestContext());
    }

    protected HttpResponse createHttpResponse() {
        return new QuarkusHttpResponse(this.getResteasyReactiveRequestContext());
    }

    public ClientConnection getConnection() {
        if (this.clientConnection == null) {
            ClientConnection contextualObject = (ClientConnection)Resteasy.getContextData(ClientConnection.class);
            if (contextualObject == null) {
                ResteasyReactiveRequestContext requestContext = this.getResteasyReactiveRequestContext();
                HttpServerRequest serverRequest = (HttpServerRequest)requestContext.unwrap(HttpServerRequest.class);
                this.clientConnection = new QuarkusClientConnection(serverRequest);
            } else {
                this.clientConnection = contextualObject;
            }
        }
        return this.clientConnection;
    }

    private ResteasyReactiveRequestContext getResteasyReactiveRequestContext() {
        return CurrentRequestManager.get();
    }
}

