/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.DotName;

public final class ApplicationArchivesBuildItem
extends SimpleBuildItem {
    private final ApplicationArchive root;
    private final Collection<ApplicationArchive> applicationArchives;
    private Set<ApplicationArchive> allArchives;

    public ApplicationArchivesBuildItem(ApplicationArchive root, Collection<ApplicationArchive> applicationArchives) {
        this.root = root;
        this.applicationArchives = applicationArchives;
    }

    public ApplicationArchive getRootArchive() {
        return this.root;
    }

    public Collection<ApplicationArchive> getApplicationArchives() {
        return this.applicationArchives;
    }

    public Set<ApplicationArchive> getAllApplicationArchives() {
        if (this.allArchives == null) {
            HashSet<ApplicationArchive> ret = new HashSet<ApplicationArchive>(this.applicationArchives);
            ret.add(this.root);
            this.allArchives = Collections.unmodifiableSet(ret);
        }
        return this.allArchives;
    }

    public ApplicationArchive containingArchive(String className) {
        return this.containingArchive(DotName.createSimple((String)className));
    }

    public ApplicationArchive containingArchive(DotName className) {
        if (this.root.getIndex().getClassByName(className) != null) {
            return this.root;
        }
        for (ApplicationArchive i : this.applicationArchives) {
            if (i.getIndex().getClassByName(className) == null) continue;
            return i;
        }
        return null;
    }
}

