/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.io.IOException;
import java.net.URI;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.keycloak.email.EmailException;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.models.ModelDuplicateException;

@MessageLogger(projectCode="KC-SERVICES", length=4)
public interface ServicesLogger
extends BasicLogger {
    public static final ServicesLogger LOGGER = (ServicesLogger)Logger.getMessageLogger(ServicesLogger.class, (String)"org.keycloak.services");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Loading config from %s")
    public void loadingFrom(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Failed to migrate datamodel")
    public void migrationFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Not importing realm %s from %s.  It already exists.")
    public void realmExists(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Imported realm %s from %s.")
    public void importedRealm(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unable to import realm %s from %s.")
    public void unableToImportRealm(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Importing users from '%s'")
    public void imprtingUsersFrom(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to load 'keycloak-add-user.json'")
    public void failedToLoadUsers(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed to add user %s to realm %s: realm not found")
    public void addUserFailedRealmNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Added user '%s' to realm '%s'")
    public void addUserSuccess(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Failed to add user '%s' to realm '%s': user with username exists")
    public void addUserFailedUserExists(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="Failed to add user '%s' to realm '%s'")
    public void addUserFailed(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="Failed to delete '%s'")
    public void failedToDeleteFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Failed authentication")
    public void failedAuthentication(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=14, value="Failed client authentication")
    public void failedClientAuthentication(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15, value="Unexpected error when authenticating client")
    public void errorAuthenticatingClient(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Unknown flow to execute with")
    public void unknownFlow();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Unknown result status")
    public void unknownResultStatus();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Client %s doesn't have have authentication method configured. Fallback to %s")
    public void authMethodFallback(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="No duplication detected.")
    public void noDuplicationDetected();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="%s is null. Reset flow and enforce showing reviewProfile page")
    public void resetFlow(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="Failed to send email to confirm identity broker linking")
    public void confirmBrokerEmailFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=22, value="Key parameter don't match with the expected value from client session")
    public void keyParamDoesNotMatch();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23, value="Smtp is not configured for the realm. Ignoring email verification authenticator")
    public void smtpNotConfigured();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=24, value="")
    public void modelDuplicateException(@Cause ModelDuplicateException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Error when validating client assertion")
    public void errorValidatingAssertion(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Failed to send password reset email")
    public void failedToSendPwdResetEmail(@Cause EmailException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=28, value="Recaptcha failed")
    public void recaptchaFailed(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=29, value="Failed to send email")
    public void failedToSendEmail(@Cause Exception var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="Full model import requested. Strategy: %s")
    public void fullModelImport(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=31, value="Import of realm '%s' requested. Strategy: %s")
    public void realmImportRequested(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=32, value="Import finished successfully")
    public void importSuccess();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=33, value="Full model export requested")
    public void fullModelExportRequested();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=34, value="Export of realm '%s' requested.")
    public void realmExportRequested(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=35, value="Export finished successfully")
    public void exportSuccess();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="Error overwriting %s")
    public void overwriteError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=37, value="Error creating %s")
    public void creationError(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=38, value="Error importing roles")
    public void roleImportError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=39, value="Untranslated protocol Error: %s so we return default SAML error")
    public void untranslatedProtocol(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=40, value="Using deprecated 'directGrantsOnly' configuration in JSON representation. It will be removed in future versions")
    public void usingDeprecatedDirectGrantsOnly();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=41, value="Invoking deprecated endpoint %s")
    public void invokingDeprecatedEndpoint(URI var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=42, value="Response_mode 'query' not allowed for implicit or hybrid flow")
    public void responseModeQueryNotAllowed();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=43, value="Client session is null")
    public void clientSessionNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=44, value="Client model in client session is null")
    public void clientModelNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=45, value="Invalid token. Token verification failed.")
    public void invalidToken();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=46, value="Multiple values found '%s' for protocol mapper '%s' but expected just single value")
    public void multipleValuesForMapper(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=47, value="%s (%s) is implementing the internal SPI %s. This SPI is internal and may change without notice")
    public void spiMayChange(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=48, value="Exception during rollback")
    public void exceptionDuringRollback(@Cause RuntimeException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=49, value="%s")
    public void clientRegistrationException(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=50, value="Initializing %s realm")
    public void initializingAdminRealm(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=51, value="Failed to logout client, continuing")
    public void failedToLogoutClient(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=52, value="Failed processing type")
    public void failedProcessingType(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=54, value="Unknown action: %s")
    public void unknownAction(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=55, value="%s")
    public void errorAuthenticating(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=56, value="Error when closing LDAP connection")
    public void errorClosingLDAP(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=57, value="Logout for client '%s' failed")
    public void logoutFailed(@Cause IOException var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=58, value="Failed to send revocation request")
    public void failedToSendRevocation(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=59, value="Availability test failed for uri '%s'")
    public void availabilityTestFailed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=60, value="Role '%s' not available in realm")
    public void roleNotInRealm(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=61, value="Error occurred during full sync of users")
    public void errorDuringFullUserSync(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=62, value="Error occurred during sync of changed users")
    public void errorDuringChangedUserSync(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=63, value="Failed to format message due to: %s")
    public void failedToFormatMessage(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=64, value="Failed to load messages")
    public void failedToloadMessages(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=65, value="Failed to update Password")
    public void failedToUpdatePassword(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=66, value="Could not fire event.")
    public void couldNotFireEvent(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=67, value="failed to parse RestartLoginCookie")
    public void failedToParseRestartLoginCookie(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=68, value="Not found serialized context in clientSession under note '%s'")
    public void notFoundSerializedCtxInClientSession(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=69, value="Flow not configured for identity provider '%s'")
    public void flowNotConfigForIDP(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=70, value="Not found configured flow with ID '%s' for identity provider '%s'")
    public void flowNotFoundForIDP(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=71, value="required action doesn't match current required action")
    public void reqdActionDoesNotMatch();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=72, value="Invalid key for email verification")
    public void invalidKeyForEmailVerification();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=73, value="User session was null")
    public void userSessionNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=74, value="Required action provider was null")
    public void actionProviderNull();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Failed to get theme request")
    public void failedToGetThemeRequest(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=76, value="Rejected non-local attempt to create initial user from %s")
    public void rejectedNonLocalAttemptToCreateInitialUser(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=77, value="Created initial admin user with username %s")
    public void createdInitialAdminUser(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=78, value="Rejected attempt to create initial user as user is already created")
    public void initialUserAlreadyCreated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=79, value="Locale not specified for messages.json")
    public void localeNotSpecified();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=80, value="Message bundle not found for language code '%s'")
    public void msgBundleNotFound(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=81, value="Message bundle not found for language code 'en'")
    public void msgBundleNotFoundForEn();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=82, value="Admin Events enabled, but no event store provider configured")
    public void noEventStoreProvider();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=83, value="Event listener '%s' registered, but provider not found")
    public void providerNotFound(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=84, value="Failed to save event")
    public void failedToSaveEvent(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=85, value="Failed to send type to %s")
    public void failedToSendType(@Cause Throwable var1, EventListenerProvider var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=86, value="Added 'kerberos' to required realm credentials")
    public void addedKerberosToRealmCredentials();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=87, value="Syncing data for mapper '%s' of type '%s'. Direction: %s")
    public void syncingDataForMapper(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=88, value="Failed to send execute actions email")
    public void failedToSendActionsEmail(@Cause EmailException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=89, value="Failed to run scheduled task %s")
    public void failedToRunScheduledTask(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=90, value="Failed to close ProviderSession")
    public void failedToCloseProviderSession(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=91, value="Request is missing scope 'openid' so it's not treated as OIDC, but just pure OAuth2 request.")
    @Once
    public void oidcScopeMissing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=92, value="Missing parameter: %s")
    public void missingParameter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=93, value="Invalid parameter value for: %s")
    public void invalidParameter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=94, value="Unsupported parameter: %s")
    public void unsupportedParameter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=95, value="Client is not allowed to initiate browser login with given response_type. %s flow is disabled for the client.")
    public void flowNotAllowed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=96, value="Not found JWK of supported keyType under jwks_uri for usage: %s")
    public void supportedJwkNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=97, value="Invalid request")
    public void invalidRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=99, value="Operation '%s' rejected. %s")
    public void clientRegistrationRequestRejected(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=100, value="ProtocolMapper '%s' of type '%s' not allowed")
    public void clientRegistrationMapperNotAllowed(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=101, value="Failed to verify remote host : %s")
    public void failedToVerifyRemoteHost(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=102, value="URL '%s' doesn't match any trustedHost or trustedDomain")
    public void urlDoesntMatch(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=103, value="Failed to reset password. User is temporarily disabled")
    public void passwordResetFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=104, value="Not creating user %s. It already exists.")
    public void notCreatingExistingUser(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=105, value="Response_mode 'query.jwt' is allowed only when the authorization response token is encrypted")
    public void responseModeQueryJwtNotAllowed();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=106, value="Created script engine '%s', version '%s' for the mime type '%s'")
    @Once
    public void scriptEngineCreated(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=107, value="Skipping create admin user. Admin already exists in realm '%s'.")
    public void addAdminUserFailedAdminExists(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=108, value="URI '%s' doesn't match any trustedHost or trustedDomain")
    public void uriDoesntMatch(String var1);
}

