/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.jpa.entity;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.storage.jpa.JpaHashUtils;

@NamedQueries(value={@NamedQuery(name="getFederatedAttributesByNameAndValue", query="select attr.userId from FederatedUserAttributeEntity attr where attr.name = :name and attr.value = :value and attr.realmId=:realmId"), @NamedQuery(name="getFederatedAttributesByNameAndLongValue", query="select attr.userId, attr.longValue from FederatedUserAttributeEntity attr where attr.name = :name and attr.longValueHash = :longValueHash and attr.realmId=:realmId"), @NamedQuery(name="getFederatedAttributesByUser", query="select attr from FederatedUserAttributeEntity attr where attr.userId = :userId and attr.realmId=:realmId"), @NamedQuery(name="deleteUserFederatedAttributesByUser", query="delete from  FederatedUserAttributeEntity attr where attr.userId = :userId and attr.realmId=:realmId"), @NamedQuery(name="deleteUserFederatedAttributesByUserAndName", query="delete from  FederatedUserAttributeEntity attr where attr.userId = :userId and attr.name=:name and attr.realmId=:realmId"), @NamedQuery(name="deleteUserFederatedAttributesByRealm", query="delete from  FederatedUserAttributeEntity attr where attr.realmId=:realmId"), @NamedQuery(name="deleteFederatedAttributesByStorageProvider", query="delete from FederatedUserAttributeEntity e where e.storageProviderId=:storageProviderId"), @NamedQuery(name="deleteUserFederatedAttributesByRealmAndLink", query="delete from  FederatedUserAttributeEntity attr where attr.userId IN (select u.id from UserEntity u where u.realmId=:realmId and u.federationLink=:link)")})
@Table(name="FED_USER_ATTRIBUTE")
@Entity
@EnhancementInfo(version="6.4.4.Final")
public class FederatedUserAttributeEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="USER_ID")
    protected String userId;
    @Column(name="REALM_ID")
    protected String realmId;
    @Column(name="STORAGE_PROVIDER_ID")
    protected String storageProviderId;
    @Column(name="NAME")
    protected String name;
    @Column(name="VALUE")
    protected String value;
    @Column(name="LONG_VALUE_HASH")
    byte[] longValueHash;
    @Column(name="LONG_VALUE_HASH_LOWER_CASE")
    byte[] longValueHashLowerCase;
    @Nationalized
    @Column(name="LONG_VALUE")
    String longValue;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getValue() {
        if (this.$$_hibernate_read_value() != null && this.$$_hibernate_read_longValue() != null) {
            throw new IllegalStateException(String.format("Federated user with id %s should not have set both `value` and `longValue` for attribute %s.", this.$$_hibernate_read_userId(), this.$$_hibernate_read_name()));
        }
        return this.$$_hibernate_read_value() != null ? this.$$_hibernate_read_value() : this.$$_hibernate_read_longValue();
    }

    public void setValue(String value) {
        if (value == null) {
            this.$$_hibernate_write_value(null);
            this.$$_hibernate_write_longValue(null);
            this.$$_hibernate_write_longValueHash(null);
            this.$$_hibernate_write_longValueHashLowerCase(null);
        } else if (value.length() > 2024) {
            this.$$_hibernate_write_value(null);
            this.$$_hibernate_write_longValue(value);
            this.$$_hibernate_write_longValueHash(JpaHashUtils.hashForAttributeValue((String)value));
            this.$$_hibernate_write_longValueHashLowerCase(JpaHashUtils.hashForAttributeValueLowerCase((String)value));
        } else {
            this.$$_hibernate_write_value(value);
            this.$$_hibernate_write_longValue(null);
            this.$$_hibernate_write_longValueHash(null);
            this.$$_hibernate_write_longValueHashLowerCase(null);
        }
    }

    public String getUserId() {
        return this.$$_hibernate_read_userId();
    }

    public void setUserId(String userId) {
        this.$$_hibernate_write_userId(userId);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public String getStorageProviderId() {
        return this.$$_hibernate_read_storageProviderId();
    }

    public void setStorageProviderId(String storageProviderId) {
        this.$$_hibernate_write_storageProviderId(storageProviderId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FederatedUserAttributeEntity)) {
            return false;
        }
        FederatedUserAttributeEntity that = (FederatedUserAttributeEntity)o;
        return this.$$_hibernate_read_id().equals(that.getId());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        FederatedUserAttributeEntity federatedUserAttributeEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        FederatedUserAttributeEntity federatedUserAttributeEntity = this;
        federatedUserAttributeEntity = null;
        federatedUserAttributeEntity = NoopCollectionTracker.INSTANCE;
        return federatedUserAttributeEntity;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_userId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "userId", (Object)this.userId);
        }
        return this.userId;
    }

    public void $$_hibernate_write_userId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"userId", (Object)string, (Object)this.userId)) {
            this.$$_hibernate_trackChange("userId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userId", (Object)this.userId, (Object)string);
            return;
        }
        this.userId = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"realmId", (Object)string, (Object)this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_storageProviderId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.storageProviderId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "storageProviderId", (Object)this.storageProviderId);
        }
        return this.storageProviderId;
    }

    public void $$_hibernate_write_storageProviderId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"storageProviderId", (Object)string, (Object)this.storageProviderId)) {
            this.$$_hibernate_trackChange("storageProviderId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.storageProviderId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "storageProviderId", (Object)this.storageProviderId, (Object)string);
            return;
        }
        this.storageProviderId = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_value() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.value = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "value", (Object)this.value);
        }
        return this.value;
    }

    public void $$_hibernate_write_value(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"value", (Object)string, (Object)this.value)) {
            this.$$_hibernate_trackChange("value");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.value = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "value", (Object)this.value, (Object)string);
            return;
        }
        this.value = string;
    }

    public byte[] $$_hibernate_read_longValueHash() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValueHash = (byte[])this.$$_hibernate_getInterceptor().readObject((Object)this, "longValueHash", (Object)this.longValueHash);
        }
        return this.longValueHash;
    }

    public void $$_hibernate_write_longValueHash(byte[] byArray) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"longValueHash", (Object)byArray, (Object)this.longValueHash)) {
            this.$$_hibernate_trackChange("longValueHash");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValueHash = (byte[])this.$$_hibernate_getInterceptor().writeObject((Object)this, "longValueHash", (Object)this.longValueHash, (Object)byArray);
            return;
        }
        this.longValueHash = byArray;
    }

    public byte[] $$_hibernate_read_longValueHashLowerCase() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValueHashLowerCase = (byte[])this.$$_hibernate_getInterceptor().readObject((Object)this, "longValueHashLowerCase", (Object)this.longValueHashLowerCase);
        }
        return this.longValueHashLowerCase;
    }

    public void $$_hibernate_write_longValueHashLowerCase(byte[] byArray) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"longValueHashLowerCase", (Object)byArray, (Object)this.longValueHashLowerCase)) {
            this.$$_hibernate_trackChange("longValueHashLowerCase");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValueHashLowerCase = (byte[])this.$$_hibernate_getInterceptor().writeObject((Object)this, "longValueHashLowerCase", (Object)this.longValueHashLowerCase, (Object)byArray);
            return;
        }
        this.longValueHashLowerCase = byArray;
    }

    public String $$_hibernate_read_longValue() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValue = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "longValue", (Object)this.longValue);
        }
        return this.longValue;
    }

    public void $$_hibernate_write_longValue(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"longValue", (Object)string, (Object)this.longValue)) {
            this.$$_hibernate_trackChange("longValue");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.longValue = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "longValue", (Object)this.longValue, (Object)string);
            return;
        }
        this.longValue = string;
    }
}

