/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;

public class ForeignKey
extends Constraint {
    private Table referencedTable;
    private String referencedEntityName;
    private String keyDefinition;
    private OnDeleteAction onDeleteAction;
    private final List<Column> referencedColumns = new ArrayList<Column>();
    private boolean creationEnabled = true;

    @Override
    public String getExportIdentifier() {
        return StringHelper.qualify(this.getTable().getExportIdentifier(), "FK-" + this.getName());
    }

    public void disableCreation() {
        this.creationEnabled = false;
    }

    public boolean isCreationEnabled() {
        return this.creationEnabled;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if ("none".equals(name)) {
            this.disableCreation();
        }
    }

    @Override
    @Deprecated(since="6.2", forRemoval=true)
    public String sqlConstraintString(SqlStringGenerationContext context, String constraintName, String defaultCatalog, String defaultSchema) {
        Dialect dialect = context.getDialect();
        String[] columnNames = new String[this.getColumnSpan()];
        String[] referencedColumnNames = new String[this.getColumnSpan()];
        List<Column> referencedColumns = this.isReferenceToPrimaryKey() ? this.referencedTable.getPrimaryKey().getColumns() : this.referencedColumns;
        List<Column> columns = this.getColumns();
        for (int i = 0; i < referencedColumns.size() && i < columns.size(); ++i) {
            columnNames[i] = columns.get(i).getQuotedName(dialect);
            referencedColumnNames[i] = referencedColumns.get(i).getQuotedName(dialect);
        }
        String result = this.keyDefinition != null ? dialect.getAddForeignKeyConstraintString(constraintName, this.keyDefinition) : dialect.getAddForeignKeyConstraintString(constraintName, columnNames, this.referencedTable.getQualifiedName(context), referencedColumnNames, this.isReferenceToPrimaryKey());
        return this.onDeleteAction != null && this.onDeleteAction != OnDeleteAction.NO_ACTION && dialect.supportsCascadeDelete() ? result + " on delete " + this.onDeleteAction.toSqlString() : result;
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    private void appendColumns(StringBuilder buf, Iterator<Column> columns) {
        while (columns.hasNext()) {
            Column column = columns.next();
            buf.append(column.getName());
            if (!columns.hasNext()) continue;
            buf.append(",");
        }
    }

    public void setReferencedTable(Table referencedTable) throws MappingException {
        this.referencedTable = referencedTable;
    }

    public void alignColumns() {
        if (this.isReferenceToPrimaryKey()) {
            int columnSpan = this.getColumnSpan();
            PrimaryKey primaryKey = this.referencedTable.getPrimaryKey();
            if (primaryKey.getColumnSpan() != columnSpan) {
                StringBuilder sb = new StringBuilder();
                sb.append("Foreign key (").append(this.getName()).append(":").append(this.getTable().getName()).append(" [");
                this.appendColumns(sb, this.getColumns().iterator());
                sb.append("])").append(") must have same number of columns as the referenced primary key (").append(this.referencedTable.getName()).append(" [");
                this.appendColumns(sb, primaryKey.getColumns().iterator());
                sb.append("])");
                throw new MappingException(sb.toString());
            }
            for (int i = 0; i < columnSpan; ++i) {
                Column referencedColumn = primaryKey.getColumn(i);
                Column referencingColumn = this.getColumn(i);
                referencingColumn.setLength(referencedColumn.getLength());
                referencingColumn.setScale(referencedColumn.getScale());
                referencingColumn.setPrecision(referencedColumn.getPrecision());
                referencingColumn.setArrayLength(referencedColumn.getArrayLength());
            }
        }
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public String getKeyDefinition() {
        return this.keyDefinition;
    }

    public void setKeyDefinition(String keyDefinition) {
        this.keyDefinition = keyDefinition;
    }

    public void setOnDeleteAction(OnDeleteAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public OnDeleteAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    @Deprecated(since="6.2")
    public boolean isCascadeDeleteEnabled() {
        return this.onDeleteAction == OnDeleteAction.CASCADE;
    }

    @Deprecated(since="6.2")
    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.onDeleteAction = cascadeDeleteEnabled ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    public boolean isPhysicalConstraint() {
        return this.referencedTable.isPhysicalTable() && this.getTable().isPhysicalTable() && !this.referencedTable.hasDenormalizedTables();
    }

    public List<Column> getReferencedColumns() {
        return this.referencedColumns;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.referencedColumns.isEmpty();
    }

    public void addReferencedColumns(List<Column> referencedColumns) {
        for (Column referencedColumn : referencedColumns) {
            this.addReferencedColumn(referencedColumn);
        }
    }

    private void addReferencedColumn(Column column) {
        if (!this.referencedColumns.contains(column)) {
            this.referencedColumns.add(column);
        }
    }

    @Override
    public String toString() {
        if (!this.isReferenceToPrimaryKey()) {
            return this.getClass().getSimpleName() + "(" + this.getTable().getName() + this.getColumns() + " ref-columns:(" + this.getReferencedColumns() + ") as " + this.getName() + ")";
        }
        return super.toString();
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "FK_";
    }
}

