/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TaskRunner;

public class ScheduledTaskRunner
implements TaskRunner {
    private static final Logger logger = Logger.getLogger(ScheduledTaskRunner.class);
    protected final KeycloakSessionFactory sessionFactory;
    protected final ScheduledTask task;
    protected final int transactionLimit;

    public ScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task) {
        this(sessionFactory, task, 0);
    }

    public ScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task, int transactionLimit) {
        this.sessionFactory = sessionFactory;
        this.task = task;
        this.transactionLimit = transactionLimit;
    }

    @Override
    public void run() {
        try {
            KeycloakModelUtils.runJobInTransaction(this.sessionFactory, session -> {
                try {
                    if (this.transactionLimit != 0) {
                        KeycloakModelUtils.setTransactionLimit(this.sessionFactory, this.transactionLimit);
                    }
                    this.runTask(session);
                }
                finally {
                    if (this.transactionLimit != 0) {
                        KeycloakModelUtils.setTransactionLimit(this.sessionFactory, 0);
                    }
                }
            });
        }
        catch (Throwable t) {
            logger.errorf(t, "Failed to run scheduled task %s", (Object)this.task.getTaskName());
        }
    }

    protected void runTask(KeycloakSession session) {
        this.task.run(session);
        logger.debugf("Executed scheduled task %s", (Object)this.task.getTaskName());
    }

    @Override
    public ScheduledTask getTask() {
        return this.task;
    }
}

