/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

@SerializeWith(value=ExternalizerImpl.class)
public class SessionEntityWrapper<S extends SessionEntity> {
    private static final Logger log = Logger.getLogger(SessionEntityWrapper.class);
    private UUID version;
    private final S entity;
    private final Map<String, String> localMetadata;

    protected SessionEntityWrapper(UUID version, Map<String, String> localMetadata, S entity) {
        if (version == null) {
            throw new IllegalArgumentException("Version UUID can't be null");
        }
        this.version = version;
        this.localMetadata = localMetadata;
        this.entity = entity;
    }

    public SessionEntityWrapper(Map<String, String> localMetadata, S entity) {
        this(UUID.randomUUID(), localMetadata, entity);
    }

    public SessionEntityWrapper(S entity) {
        this(new ConcurrentHashMap<String, String>(), entity);
    }

    private SessionEntityWrapper(S entity, boolean forTransport) {
        if (!forTransport) {
            throw new IllegalArgumentException("This constructor is only for transport entities");
        }
        this.version = null;
        this.localMetadata = null;
        this.entity = entity;
    }

    public static <S extends SessionEntity> SessionEntityWrapper<S> forTransport(S entity) {
        return new SessionEntityWrapper<S>(entity, true);
    }

    public SessionEntityWrapper<S> forTransport() {
        return new SessionEntityWrapper<S>(this.entity, true);
    }

    private boolean isForTransport() {
        return this.version == null;
    }

    public UUID getVersion() {
        return this.version;
    }

    public void setVersion(UUID version) {
        this.version = version;
    }

    public S getEntity() {
        return this.entity;
    }

    public ClientModel getClientIfNeeded(RealmModel realm) {
        String clientId;
        if (this.entity instanceof AuthenticatedClientSessionEntity && (clientId = ((AuthenticatedClientSessionEntity)this.entity).getClientId()) != null) {
            return realm.getClientById(clientId);
        }
        return null;
    }

    public String getLocalMetadataNote(String key) {
        if (this.isForTransport()) {
            throw new IllegalStateException("This entity is only intended for transport");
        }
        return this.localMetadata.get(key);
    }

    public void putLocalMetadataNote(String key, String value) {
        if (this.isForTransport()) {
            throw new IllegalStateException("This entity is only intended for transport");
        }
        this.localMetadata.put(key, value);
    }

    public Integer getLocalMetadataNoteInt(String key) {
        String note = this.getLocalMetadataNote(key);
        return note == null ? null : Integer.valueOf(note);
    }

    public void putLocalMetadataNoteInt(String key, int value) {
        if (this.isForTransport()) {
            throw new IllegalStateException("This entity is only intended for transport");
        }
        this.localMetadata.put(key, String.valueOf(value));
    }

    public Map<String, String> getLocalMetadata() {
        return this.localMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionEntityWrapper)) {
            return false;
        }
        SessionEntityWrapper that = (SessionEntityWrapper)o;
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hashCode(this.version) * 17 + Objects.hashCode(this.entity);
    }

    public String toString() {
        return "SessionEntityWrapper{version=" + this.version + ", entity=" + this.entity + ", localMetadata=" + this.localMetadata + "}";
    }

    public static class ExternalizerImpl
    implements Externalizer<SessionEntityWrapper> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, SessionEntityWrapper obj) throws IOException {
            output.writeByte(1);
            boolean forTransport = obj.isForTransport();
            output.writeBoolean(forTransport);
            if (!forTransport) {
                output.writeLong(obj.getVersion().getMostSignificantBits());
                output.writeLong(obj.getVersion().getLeastSignificantBits());
                MarshallUtil.marshallMap(obj.localMetadata, (ObjectOutput)output);
            }
            output.writeObject(obj.entity);
        }

        public SessionEntityWrapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte version = input.readByte();
            if (version != 1) {
                throw new IOException("Invalid version: " + version);
            }
            boolean forTransport = input.readBoolean();
            if (forTransport) {
                SessionEntity entity = (SessionEntity)input.readObject();
                SessionEntityWrapper<SessionEntity> res = new SessionEntityWrapper<SessionEntity>(entity);
                if (log.isTraceEnabled()) {
                    log.tracef("Loaded entity from remote store: %s, version=%s, metadata=%s", (Object)entity, (Object)res.version, res.localMetadata);
                }
                return res;
            }
            UUID sessionVersion = new UUID(input.readLong(), input.readLong());
            HashMap map = (HashMap)MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
            SessionEntity entity = (SessionEntity)input.readObject();
            if (log.isTraceEnabled()) {
                log.tracef("Found entity locally: entity=%s, version=%s, metadata=%s", (Object)entity, (Object)sessionVersion, (Object)map);
            }
            return new SessionEntityWrapper<SessionEntity>(sessionVersion, map, entity);
        }
    }
}

