/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.connections.infinispan.DefaultInfinispanConnectionProviderFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoaderContext;

public class RemoteCacheSessionsLoader
implements SessionLoader<RemoteCacheSessionsLoaderContext, SessionLoader.WorkerContext, SessionLoader.WorkerResult>,
Serializable {
    private static final Logger log = Logger.getLogger(RemoteCacheSessionsLoader.class);
    private final String cacheName;
    private final int sessionsPerSegment;

    public RemoteCacheSessionsLoader(String cacheName, int sessionsPerSegment) {
        this.cacheName = cacheName;
        this.sessionsPerSegment = sessionsPerSegment;
    }

    @Override
    public void init(KeycloakSession session) {
    }

    @Override
    public RemoteCacheSessionsLoaderContext computeLoaderContext(KeycloakSession session) {
        return new RemoteCacheSessionsLoaderContext(this.sessionsPerSegment);
    }

    @Override
    public SessionLoader.WorkerContext computeWorkerContext(RemoteCacheSessionsLoaderContext loaderCtx, int segment, int workerId, SessionLoader.WorkerResult previousResult) {
        return new SessionLoader.WorkerContext(segment, workerId);
    }

    @Override
    public SessionLoader.WorkerResult createFailedWorkerResult(RemoteCacheSessionsLoaderContext loaderContext, SessionLoader.WorkerContext workerContext) {
        return new SessionLoader.WorkerResult(false, workerContext.getSegment(), workerContext.getWorkerId());
    }

    @Override
    public SessionLoader.WorkerResult loadSessions(KeycloakSession session, RemoteCacheSessionsLoaderContext loaderContext, SessionLoader.WorkerContext ctx) {
        Cache cache = this.getCache(session);
        AdvancedCache decoratedCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE, Flag.IGNORE_RETURN_VALUES});
        RemoteCache remoteCache = this.getRemoteCache(session);
        int countLoaded = 0;
        try (CloseableIterator it = remoteCache.retrieveEntriesWithMetadata(null, loaderContext.getSessionsPerSegment());){
            HashMap<Object, Object> toInsertExpiring = new HashMap<Object, Object>(loaderContext.getSessionsPerSegment());
            HashMap<Object, Object> toInsertImmortal = new HashMap<Object, Object>(loaderContext.getSessionsPerSegment());
            int count = 0;
            int maxLifespanExpiring = 0;
            int maxIdleExpiring = -1;
            int maxIdleImmortal = -1;
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                boolean isImmortal = ((MetadataValue)entry.getValue()).getLifespan() < 0;
                boolean shouldInsert = true;
                if (!isImmortal) {
                    int remainingLifespan = ((MetadataValue)entry.getValue()).getLifespan() - (int)((System.currentTimeMillis() - ((MetadataValue)entry.getValue()).getCreated()) / 1000L);
                    maxLifespanExpiring = Math.max(maxLifespanExpiring, remainingLifespan);
                    if (remainingLifespan <= 0) {
                        shouldInsert = false;
                    }
                }
                if (((MetadataValue)entry.getValue()).getMaxIdle() > 0) {
                    if (isImmortal) {
                        maxIdleImmortal = Math.max(maxIdleImmortal, ((MetadataValue)entry.getValue()).getMaxIdle());
                    } else {
                        maxIdleExpiring = Math.max(maxIdleExpiring, ((MetadataValue)entry.getValue()).getMaxIdle());
                    }
                }
                if (shouldInsert) {
                    (isImmortal ? toInsertImmortal : toInsertExpiring).put(entry.getKey(), ((MetadataValue)entry.getValue()).getValue());
                    ++countLoaded;
                }
                if (++count != loaderContext.getSessionsPerSegment()) continue;
                if (!toInsertExpiring.isEmpty()) {
                    this.insertSessions((Cache<Object, Object>)decoratedCache, toInsertExpiring, maxIdleExpiring, maxLifespanExpiring);
                    toInsertExpiring.clear();
                    maxLifespanExpiring = 0;
                    maxIdleExpiring = -1;
                }
                if (!toInsertImmortal.isEmpty()) {
                    this.insertSessions((Cache<Object, Object>)decoratedCache, toInsertImmortal, maxIdleImmortal, -1);
                    toInsertImmortal.clear();
                    maxIdleImmortal = -1;
                }
                count = 0;
            }
            if (!toInsertExpiring.isEmpty()) {
                this.insertSessions((Cache<Object, Object>)decoratedCache, toInsertExpiring, maxIdleExpiring, maxLifespanExpiring);
            }
            if (!toInsertImmortal.isEmpty()) {
                this.insertSessions((Cache<Object, Object>)decoratedCache, toInsertImmortal, maxIdleImmortal, -1);
            }
        }
        catch (RuntimeException e) {
            log.warnf((Throwable)e, "Error loading sessions from remote cache '%s' for segment '%d'", (Object)remoteCache.getName(), (Object)ctx.getSegment());
            throw e;
        }
        log.debugf("Successfully finished loading sessions from cache '%s' . Segment: %d, Count of sessions loaded: %d", (Object)cache.getName(), (Object)ctx.getSegment(), (Object)countLoaded);
        return new SessionLoader.WorkerResult(true, ctx.getSegment(), ctx.getWorkerId());
    }

    private void insertSessions(Cache<Object, Object> cache, Map<Object, Object> entries, int maxIdle, int lifespan) {
        log.debugf("Adding %d entries to cache '%s'", entries.size(), (Object)this.cacheName);
        Retry.executeWithBackoff(iteration -> DefaultInfinispanConnectionProviderFactory.runWithReadLockOnCacheManager(() -> cache.putAll(entries, (long)lifespan, TimeUnit.SECONDS, (long)maxIdle, TimeUnit.SECONDS)), (iteration, throwable) -> log.warnf("Unable to put entries into the cache in iteration %s", (Object)iteration, (Object)throwable), (int)3, (int)10);
    }

    @Override
    public boolean isFinished(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Boolean sessionsLoaded = (Boolean)workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}).get((Object)"PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC");
        if ((this.cacheName.equals("offlineSessions") || this.cacheName.equals("offlineClientSessions")) && sessionsLoaded != null && sessionsLoaded.booleanValue()) {
            log.debugf("Sessions already loaded in current DC. Skip sessions loading from remote cache '%s'", (Object)this.cacheName);
            return true;
        }
        log.debugf("Sessions maybe not yet loaded in current DC. Will load them from remote cache '%s'", (Object)this.cacheName);
        return false;
    }

    @Override
    public void afterAllSessionsLoaded(BaseCacheInitializer initializer) {
    }

    protected Cache getCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getCache(this.cacheName);
    }

    protected RemoteCache getRemoteCache(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        return ispn.getRemoteCache(this.cacheName);
    }

    public String toString() {
        return "RemoteCacheSessionsLoader [ " + "cacheName: " + this.cacheName + ", sessionsPerSegment: " + this.sessionsPerSegment + " ]";
    }
}

