/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.cors.Cors;

public class AuthorizeClientUtil {
    private static final Logger logger = Logger.getLogger(AuthorizeClientUtil.class);

    public static ClientAuthResult authorizeClient(KeycloakSession session, EventBuilder event, Cors cors) {
        String protocol;
        AuthenticationProcessor processor = AuthorizeClientUtil.getAuthenticationProcessor(session, event);
        Response response = processor.authenticateClient();
        if (response != null) {
            if (cors != null) {
                cors.allowAllOrigins();
                HttpResponse httpResponse = session.getContext().getHttpResponse();
                cors.build(httpResponse);
            }
            throw new WebApplicationException(response);
        }
        ClientModel client = processor.getClient();
        if (client == null) {
            AuthorizeClientUtil.throwErrorResponseException("invalid_client", "Client authentication ended, but client is null", Response.Status.BAD_REQUEST, cors.allowAllOrigins());
        }
        if (!client.isEnabled()) {
            event.error("client_disabled");
            AuthorizeClientUtil.throwErrorResponseException("invalid_client", "Invalid client or Invalid client credentials", Response.Status.UNAUTHORIZED, cors.allowAllOrigins());
        }
        if (cors != null) {
            cors.allowedOrigins(session, client);
        }
        if ((protocol = client.getProtocol()) == null) {
            logger.warnf("Client '%s' doesn't have protocol set. Fallback to openid-connect. Please fix client configuration", (Object)client.getClientId());
            protocol = "openid-connect";
        }
        if (!protocol.equals("openid-connect")) {
            event.error("invalid_client");
            AuthorizeClientUtil.throwErrorResponseException("invalid_client", "Wrong client protocol.", Response.Status.BAD_REQUEST, cors);
        }
        session.getContext().setClient(client);
        return new ClientAuthResult(client, processor.getClientAuthAttributes());
    }

    public static AuthenticationProcessor getAuthenticationProcessor(KeycloakSession session, EventBuilder event) {
        RealmModel realm = session.getContext().getRealm();
        AuthenticationFlowModel clientAuthFlow = realm.getClientAuthenticationFlow();
        String flowId = clientAuthFlow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setFlowId(flowId).setConnection(session.getContext().getConnection()).setEventBuilder(event).setRealm(realm).setSession(session).setUriInfo((UriInfo)session.getContext().getUri()).setRequest(session.getContext().getHttpRequest());
        return processor;
    }

    public static ClientAuthenticatorFactory findClientAuthenticatorForOIDCAuthMethod(KeycloakSession session, String oidcAuthMethod) {
        return session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class).map(ClientAuthenticatorFactory.class::cast).filter(caf -> caf.getProtocolAuthenticatorMethods("openid-connect").contains(oidcAuthMethod)).findFirst().orElse(null);
    }

    private static void throwErrorResponseException(String error, String errorDescription, Response.Status status, Cors cors) {
        if (cors == null) {
            throw new ErrorResponseException(error, errorDescription, status);
        }
        cors.allowAllOrigins();
        throw new CorsErrorResponseException(cors, error, errorDescription, status);
    }

    public static class ClientAuthResult {
        private final ClientModel client;
        private final Map<String, String> clientAuthAttributes;

        private ClientAuthResult(ClientModel client, Map<String, String> clientAuthAttributes) {
            this.client = client;
            this.clientAuthAttributes = clientAuthAttributes;
        }

        public ClientModel getClient() {
            return this.client;
        }

        public Map<String, String> getClientAuthAttributes() {
            return this.clientAuthAttributes;
        }
    }
}

