/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.ClientProfileRepresentation;
import org.keycloak.services.clientpolicy.ClientPoliciesUtil;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.services.clientpolicy.ClientPolicyManagerFactory;
import org.keycloak.services.clientpolicy.DefaultClientPolicyManager;

public class DefaultClientPolicyManagerFactory
implements ClientPolicyManagerFactory {
    private static final Logger logger = Logger.getLogger(DefaultClientPolicyManagerFactory.class);
    private volatile List<ClientProfileRepresentation> globalClientProfiles;

    public ClientPolicyManager create(KeycloakSession session) {
        return new DefaultClientPolicyManager(session, () -> this.getGlobalClientProfiles(session));
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ClientProfileRepresentation> getGlobalClientProfiles(KeycloakSession session) {
        if (this.globalClientProfiles == null) {
            DefaultClientPolicyManagerFactory defaultClientPolicyManagerFactory = this;
            synchronized (defaultClientPolicyManagerFactory) {
                if (this.globalClientProfiles == null) {
                    logger.trace((Object)"LOAD GLOBAL CLIENT PROFILES ON KEYCLOAK");
                    try {
                        this.globalClientProfiles = ClientPoliciesUtil.getValidatedGlobalClientProfilesRepresentation(session, this.getClass().getResourceAsStream("/keycloak-default-client-profiles.json"));
                    }
                    catch (ClientPolicyException cpe) {
                        logger.warnv("LOAD GLOBAL PROFILES ON KEYCLOAK FAILED :: error = {0}, error detail = {1}", (Object)cpe.getError(), (Object)cpe.getErrorDetail());
                        throw new IllegalStateException(cpe);
                    }
                }
            }
        }
        return this.globalClientProfiles;
    }
}

