/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.error;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.Failure;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;
import org.keycloak.forms.login.MessageType;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.utils.MediaType;
import org.keycloak.utils.MediaTypeMatcher;

public class KeycloakErrorHandler
implements ExceptionMapper<Throwable> {
    private static final Logger logger = Logger.getLogger(KeycloakErrorHandler.class);
    private static final Pattern realmNamePattern = Pattern.compile(".*/realms/([^/]+).*");
    public static final String UNCAUGHT_SERVER_ERROR_TEXT = "Uncaught server error";
    public static final String ERROR_RESPONSE_TEXT = "Error response {0}";

    public Response toResponse(final Throwable throwable) {
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        if (session == null) {
            return (Response)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)KeycloakApplication.getSessionFactory(), (KeycloakSessionTaskWithResult)new KeycloakSessionTaskWithResult<Response>(){

                public Response run(KeycloakSession session) {
                    return KeycloakErrorHandler.getResponse(session, throwable);
                }
            });
        }
        return KeycloakErrorHandler.getResponse(session, throwable);
    }

    public static Response getResponse(KeycloakSession session, Throwable throwable) {
        KeycloakTransactionManager tx = session.getTransactionManager();
        tx.setRollbackOnly();
        int statusCode = KeycloakErrorHandler.getStatusCode(throwable);
        if (statusCode >= 500 && statusCode <= 599) {
            logger.error((Object)UNCAUGHT_SERVER_ERROR_TEXT, throwable);
        } else {
            logger.debugv(throwable, ERROR_RESPONSE_TEXT, (Object)statusCode);
        }
        HttpHeaders headers = session.getContext().getRequestHeaders();
        if (!MediaTypeMatcher.isHtmlRequest(headers)) {
            OAuth2ErrorRepresentation error = new OAuth2ErrorRepresentation();
            error.setError(KeycloakErrorHandler.getErrorCode(throwable));
            error.setErrorDescription("For more on this error consult the server log at the debug level.");
            return Response.status((int)statusCode).header("Content-Type", (Object)jakarta.ws.rs.core.MediaType.APPLICATION_JSON_TYPE.toString()).entity((Object)error).build();
        }
        try {
            RealmModel realm = KeycloakErrorHandler.resolveRealm(session);
            Theme theme = session.theme().getTheme(Theme.Type.LOGIN);
            Locale locale = session.getContext().resolveLocale(null);
            FreeMarkerProvider freeMarker = (FreeMarkerProvider)session.getProvider(FreeMarkerProvider.class);
            Map<String, Object> attributes = KeycloakErrorHandler.initAttributes(session, realm, theme, locale, statusCode);
            String templateName = "error.ftl";
            String content = freeMarker.processTemplate(attributes, templateName, theme);
            return Response.status((int)statusCode).type(MediaType.TEXT_HTML_UTF_8_TYPE).entity((Object)content).build();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to create error page", t);
            return Response.serverError().build();
        }
    }

    private static int getStatusCode(Throwable throwable) {
        int status = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        if (throwable instanceof WebApplicationException) {
            WebApplicationException ex = (WebApplicationException)throwable;
            status = ex.getResponse().getStatus();
        }
        if (throwable instanceof Failure) {
            Failure f = (Failure)throwable;
            status = f.getErrorCode();
        }
        if (throwable instanceof JsonProcessingException) {
            status = Response.Status.BAD_REQUEST.getStatusCode();
        }
        if (throwable instanceof ModelDuplicateException) {
            status = Response.Status.CONFLICT.getStatusCode();
        }
        return status;
    }

    private static String getErrorCode(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause instanceof JsonParseException) {
            return "invalid_request";
        }
        if (throwable instanceof WebApplicationException && throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        return "unknown_error";
    }

    private static RealmModel resolveRealm(KeycloakSession session) {
        RealmManager realmManager = new RealmManager(session);
        String path = session.getContext().getUri().getPath();
        Matcher m = realmNamePattern.matcher(path);
        String realmName = m.matches() ? m.group(1) : Config.getAdminRealm();
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            realm = realmManager.getRealmByName(Config.getAdminRealm());
        }
        session.getContext().setRealm(realm);
        return realm;
    }

    private static Map<String, Object> initAttributes(KeycloakSession session, RealmModel realm, Theme theme, Locale locale, int statusCode) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Properties messagesBundle = theme.getMessages(locale);
        attributes.put("statusCode", statusCode);
        attributes.put("realm", realm);
        attributes.put("url", new UrlBean(realm, theme, session.getContext().getUri().getBaseUri(), null));
        attributes.put("locale", new LocaleBean(realm, locale, session.getContext().getUri().getRequestUriBuilder(), messagesBundle));
        String errorKey = statusCode == 404 ? "pageNotFound" : "internalServerError";
        String errorMessage = messagesBundle.getProperty(errorKey);
        attributes.put("message", new MessageBean(errorMessage, MessageType.ERROR));
        try {
            attributes.put("msg", new MessageFormatterMethod(locale, theme.getMessages(locale)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attributes;
    }
}

