/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.SQLType;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleShardingKeyBuilder;
import oracle.jdbc.pool.OracleShardingKeyImpl;

public class OracleShardingKeyBuilderImpl
implements OracleShardingKeyBuilder {
    public static final long DEFAULT_ORA_HASH = -1L;
    private final List<Object> subKeyObjects = new ArrayList<Object>();
    private final List<SQLType> subKeyTypes = new ArrayList<SQLType>();
    private long oraHash = -1L;
    private boolean isBuilt = false;

    @Override
    public OracleShardingKeyBuilderImpl subkey(Object subkey, SQLType subkeyType) {
        if (subkey == null) {
            throw new IllegalArgumentException("Null sharding key is not allowed");
        }
        this.subKeyObjects.add(subkey);
        this.subKeyTypes.add(subkeyType);
        return this;
    }

    public OracleShardingKeyBuilderImpl oraHash(long oraHash) {
        this.oraHash = oraHash;
        return this;
    }

    @Override
    public OracleShardingKeyImpl build() {
        if (this.isBuilt) {
            throw new IllegalStateException("build() method can be used only once on a builder object");
        }
        this.isBuilt = true;
        return new OracleShardingKeyImpl(this);
    }

    List<Object> subKeyObjects() {
        return this.subKeyObjects;
    }

    List<SQLType> subKeyTypes() {
        return this.subKeyTypes;
    }

    long getOraHash() {
        return this.oraHash;
    }
}

