/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.cors;

import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.cors.Cors;

public class DefaultCors
implements Cors {
    private static final Logger logger = Logger.getLogger(DefaultCors.class);
    private final HttpRequest request;
    private final HttpResponse response;
    private Response.ResponseBuilder builder;
    private Set<String> allowedOrigins;
    private Set<String> allowedMethods;
    private Set<String> exposedHeaders;
    private boolean preflight;
    private boolean auth;

    DefaultCors(KeycloakSession session) {
        this.request = session.getContext().getHttpRequest();
        this.response = session.getContext().getHttpResponse();
    }

    public Cors builder(Response.ResponseBuilder builder) {
        this.builder = builder;
        return this;
    }

    public Cors preflight() {
        this.preflight = true;
        return this;
    }

    public Cors auth() {
        this.auth = true;
        return this;
    }

    public Cors allowAllOrigins() {
        this.allowedOrigins = Collections.singleton("*");
        return this;
    }

    public Cors allowedOrigins(KeycloakSession session, ClientModel client) {
        if (client != null) {
            this.allowedOrigins = WebOriginsUtils.resolveValidWebOrigins(session, client);
        }
        return this;
    }

    public Cors allowedOrigins(AccessToken token) {
        if (token != null) {
            this.allowedOrigins = token.getAllowedOrigins();
        }
        return this;
    }

    public Cors allowedOrigins(String ... allowedOrigins) {
        if (allowedOrigins != null && allowedOrigins.length > 0) {
            this.allowedOrigins = new HashSet<String>(Arrays.asList(allowedOrigins));
        }
        return this;
    }

    public Cors allowedMethods(String ... allowedMethods) {
        this.allowedMethods = new HashSet<String>(Arrays.asList(allowedMethods));
        return this;
    }

    public Cors exposedHeaders(String ... exposedHeaders) {
        if (this.exposedHeaders == null) {
            this.exposedHeaders = new HashSet<String>();
        }
        this.exposedHeaders.addAll(Arrays.asList(exposedHeaders));
        return this;
    }

    public void add() {
        if (this.request == null) {
            throw new IllegalStateException("request is not set");
        }
        if (this.response == null) {
            throw new IllegalStateException("response is not set");
        }
        String origin = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin");
        if (origin == null) {
            logger.trace((Object)"No Origin header, ignoring");
            return;
        }
        if (!(this.preflight || this.allowedOrigins != null && (this.allowedOrigins.contains(origin) || this.allowedOrigins.contains("*")))) {
            if (logger.isDebugEnabled()) {
                logger.debugv("Invalid CORS request: origin {0} not in allowed origins {1}", (Object)origin, this.allowedOrigins);
            }
            return;
        }
        this.response.setHeader("Access-Control-Allow-Origin", origin);
        if (this.preflight) {
            if (this.allowedMethods != null) {
                this.response.setHeader("Access-Control-Allow-Methods", CollectionUtil.join(this.allowedMethods));
            } else {
                this.response.setHeader("Access-Control-Allow-Methods", "GET, HEAD, OPTIONS");
            }
        }
        if (!this.preflight && this.exposedHeaders != null) {
            this.response.setHeader("Access-Control-Expose-Headers", CollectionUtil.join(this.exposedHeaders));
        }
        this.response.setHeader("Access-Control-Allow-Credentials", Boolean.toString(this.auth));
        if (this.preflight) {
            if (this.auth) {
                this.response.setHeader("Access-Control-Allow-Headers", String.format("%s, %s", "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, DPoP", "Authorization"));
            } else {
                this.response.setHeader("Access-Control-Allow-Headers", "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers, DPoP");
            }
        }
        if (this.preflight) {
            this.response.setHeader("Access-Control-Max-Age", String.valueOf(DEFAULT_MAX_AGE));
        }
    }

    public void close() {
    }
}

