/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.XSiteNamedCache;

@ProtoTypeId(value=1009)
public class IracMetadata {
    private final ByteString site;
    private final IracEntryVersion version;

    @ProtoFactory
    public IracMetadata(String site, IracEntryVersion version) {
        this(XSiteNamedCache.cachedByteString(Objects.requireNonNull(site)), Objects.requireNonNull(version));
    }

    public IracMetadata(ByteString site, IracEntryVersion version) {
        this.site = Objects.requireNonNull(site);
        this.version = Objects.requireNonNull(version);
    }

    public static void writeTo(ObjectOutput output, IracMetadata metadata) throws IOException {
        if (metadata == null) {
            output.writeObject(null);
            return;
        }
        output.writeObject(metadata.version);
        ByteString.writeObject(output, metadata.site);
    }

    public static IracMetadata readFrom(ObjectInput in) throws IOException, ClassNotFoundException {
        IracEntryVersion version = (IracEntryVersion)in.readObject();
        return version == null ? null : new IracMetadata(XSiteNamedCache.cachedByteString(ByteString.readObject(in)), version);
    }

    @ProtoField(value=1)
    public String getSite() {
        return this.site.toString();
    }

    @ProtoField(value=2)
    public IracEntryVersion getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IracMetadata that = (IracMetadata)o;
        return this.site.equals(that.site) && this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.site.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return "IracMetadata{site='" + String.valueOf(this.site) + "', version=" + String.valueOf(this.version) + "}";
    }
}

