/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.KcEnvConfigSource;
import org.keycloak.quarkus.runtime.configuration.KeycloakPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;

public class KeycloakConfigSourceProvider
implements ConfigSourceProvider,
ConfigBuilder {
    private static final List<ConfigSource> CONFIG_SOURCES = new ArrayList<ConfigSource>();
    private static final Map<String, String> CONFIG_SOURCE_DISPLAY_NAMES = new HashMap<String, String>();

    private static void initializeSources() {
        String profile = Environment.getProfile();
        if (profile != null) {
            System.setProperty("quarkus.profile", profile);
        }
        KeycloakConfigSourceProvider.addConfigSources("CLI", List.of(new ConfigArgsConfigSource()));
        KeycloakConfigSourceProvider.addConfigSources("ENV", List.of(new KcEnvConfigSource()));
        KeycloakConfigSourceProvider.addConfigSources("quarkus.properties", (Collection<ConfigSource>)new QuarkusPropertiesConfigSource().getConfigSources(Thread.currentThread().getContextClassLoader()));
        KeycloakConfigSourceProvider.addConfigSources("Persisted", List.of(PersistedConfigSource.getInstance()));
        KeycloakPropertiesConfigSource.InFileSystem inFileSystem = new KeycloakPropertiesConfigSource.InFileSystem();
        Path path = inFileSystem.getConfigurationFile();
        if (path != null) {
            KeycloakConfigSourceProvider.addConfigSources(path.getFileName().toString(), inFileSystem.getConfigSources(Thread.currentThread().getContextClassLoader(), path));
        }
        KeycloakConfigSourceProvider.addConfigSources("classpath keycloak.conf", (Collection<ConfigSource>)new KeycloakPropertiesConfigSource.InClassPath().getConfigSources(Thread.currentThread().getContextClassLoader()));
    }

    private static void addConfigSources(String displayName, Collection<ConfigSource> configSources) {
        for (ConfigSource cs : configSources) {
            CONFIG_SOURCES.add(cs);
            CONFIG_SOURCE_DISPLAY_NAMES.put(cs.getName(), displayName);
        }
    }

    public static void reload() {
        CONFIG_SOURCES.clear();
        CONFIG_SOURCE_DISPLAY_NAMES.clear();
        KeycloakConfigSourceProvider.initializeSources();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (Environment.isTestLaunchMode()) {
            KeycloakConfigSourceProvider.reload();
        }
        return CONFIG_SOURCES;
    }

    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        return builder.withSources(CONFIG_SOURCES);
    }

    public static String getConfigSourceDisplayName(String configSource) {
        if (configSource == null) {
            return "Derived";
        }
        if (configSource.startsWith("KeyStoreConfigSource")) {
            return "config-keystore";
        }
        return CONFIG_SOURCE_DISPLAY_NAMES.getOrDefault(configSource, configSource);
    }

    static {
        KeycloakConfigSourceProvider.initializeSources();
    }
}

