/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.common.annotation.Blocking;
import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.ApplicationPath;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;

@ApplicationPath(value="/")
@Blocking
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    private static final String KEYCLOAK_ADMIN_ENV_VAR = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_ADMIN_PROP_VAR = "keycloakAdmin";
    private static final String KEYCLOAK_ADMIN_PASSWORD_ENV_VAR = "KEYCLOAK_ADMIN_PASSWORD";
    private static final String KEYCLOAK_ADMIN_PASSWORD_PROP_VAR = "keycloakAdminPassword";

    void onStartupEvent(@Observes StartupEvent event) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        platform.started();
        this.startup();
        if (!Environment.isImportExportMode()) {
            this.createAdminUser();
        }
    }

    void onShutdownEvent(@Observes ShutdownEvent event) {
        this.shutdown();
    }

    public KeycloakSessionFactory createSessionFactory() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        instance.init();
        return instance;
    }

    protected void loadConfig() {
    }

    private void createAdminUser() {
        String adminUserName = this.getEnvOrProp(KEYCLOAK_ADMIN_ENV_VAR, KEYCLOAK_ADMIN_PROP_VAR);
        String adminPassword = this.getEnvOrProp(KEYCLOAK_ADMIN_PASSWORD_ENV_VAR, KEYCLOAK_ADMIN_PASSWORD_PROP_VAR);
        if (adminUserName == null || adminUserName.trim().length() == 0 || adminPassword == null || adminPassword.trim().length() == 0) {
            return;
        }
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        try {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, session -> new ApplianceBootstrap(session).createMasterRealmUser(adminUserName, adminPassword));
        }
        catch (Throwable t) {
            ServicesLogger.LOGGER.addUserFailed(t, adminUserName, Config.getAdminRealm());
        }
    }

    private String getEnvOrProp(String envKey, String propKey) {
        String value = System.getenv(envKey);
        return value != null ? value : System.getProperty(propKey);
    }
}

