/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo25_0_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("25.0.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo25_0_0.class);

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> this.migrateRealm(session, (RealmModel)realm));
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        ClientScopeModel basicScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"basic");
        if (basicScope == null) {
            basicScope = migrationProvider.addOIDCBasicClientScope(realm);
            session.clients().addClientScopeToAllClients(realm, basicScope, true);
        } else {
            LOG.warnf("Client scope '%s' already exists in the realm '%s'. Please migrate this realm manually if you need basic claims in your tokens.", (Object)basicScope.getName(), (Object)realm.getName());
        }
        session.sessions().migrate(VERSION.toString());
    }
}

