/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import java.io.File;
import java.io.PrintWriter;
import org.keycloak.client.cli.common.BaseConfigCredentialsCmd;
import org.keycloak.client.cli.common.BaseGlobalOptionsCmd;
import org.keycloak.client.cli.common.CommandState;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.config.ConfigHandler;
import org.keycloak.client.cli.config.FileConfigHandler;
import org.keycloak.client.cli.config.InMemoryConfigHandler;
import org.keycloak.client.cli.config.RealmConfigData;
import org.keycloak.client.cli.util.AuthUtil;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import picocli.CommandLine;

public abstract class BaseAuthOptionsCmd
extends BaseGlobalOptionsCmd {
    public static final String DEFAULT_CONFIG_PATH_STRING_KEY = "default.config.path.string";
    @CommandLine.Option(names={"--config"}, description={"Path to the config file (${sys:default.config.path.string} by default)"})
    protected String config;
    @CommandLine.Option(names={"--no-config"}, description={"Don't use config file - no authentication info is loaded or saved"})
    protected boolean noconfig;
    @CommandLine.Option(names={"--server"}, description={"Server endpoint url (e.g. 'http://localhost:8080')"})
    protected String server;
    @CommandLine.Option(names={"--realm"}, description={"Realm name to authenticate against"})
    protected String realm;
    @CommandLine.Option(names={"--client"}, description={"Realm name to authenticate against"})
    protected String clientId;
    @CommandLine.Option(names={"--user"}, description={"Username to login with"})
    protected String user;
    @CommandLine.Option(names={"--password"}, description={"Password to login with (prompted for if not specified, --user is used, and the env variable KC_CLI_PASSWORD is not defined)"}, defaultValue="${env:KC_CLI_PASSWORD}")
    protected String password;
    @CommandLine.Option(names={"--secret"}, description={"Secret to authenticate the client (prompted for if no --user nor --keystore is specified, and the env variable KC_CLI_CLIENT_SECRET is not defined)"}, defaultValue="${env:KC_CLI_CLIENT_SECRET}")
    protected String secret;
    @CommandLine.Option(names={"--keystore"}, description={"Path to a keystore containing private key"})
    protected String keystore;
    @CommandLine.Option(names={"--storepass"}, description={"Keystore password (prompted for if not specified, --keystore is used, and the env variable KC_CLI_STORE_PASSWORD is undefined)"}, defaultValue="${env:KC_CLI_STORE_PASSWORD}")
    protected String storePass;
    @CommandLine.Option(names={"--keypass"}, description={"Key password (prompted for if not specified and --keystore is used without --storepass, \n                             otherwise defaults to keystore password)"}, defaultValue="${env:KC_CLI_KEY_PASSWORD}")
    protected String keyPass;
    @CommandLine.Option(names={"--alias"}, description={"Alias of the key inside a keystore (defaults to the value of ClientId)"})
    protected String alias;
    @CommandLine.Option(names={"--truststore"}, description={"Path to a truststore"})
    protected String trustStore;
    @CommandLine.Option(names={"--trustpass"}, description={"Truststore password (prompted for if not specified, --user is used, and the env variable KC_CLI_TRUSTSTORE_PASSWORD is not defined)"}, defaultValue="${env:KC_CLI_TRUSTSTORE_PASSWORD}")
    protected String trustPass;
    @CommandLine.Option(names={"--insecure"}, description={"Turns off TLS validation"})
    protected boolean insecure;
    protected String externalToken;
    protected CommandState commandState;

    public BaseAuthOptionsCmd(CommandState state) {
        this.commandState = state;
    }

    protected String getCommand() {
        return this.commandState.getCommand();
    }

    protected String getDefaultConfigFilePath() {
        return this.commandState.getDefaultConfigFilePath();
    }

    protected void initFromParent(BaseAuthOptionsCmd parent) {
        this.noconfig = parent.noconfig;
        this.config = parent.config;
        this.server = parent.server;
        this.realm = parent.realm;
        this.clientId = parent.clientId;
        this.user = parent.user;
        this.password = parent.password;
        this.secret = parent.secret;
        this.keystore = parent.keystore;
        this.storePass = parent.storePass;
        this.keyPass = parent.keyPass;
        this.alias = parent.alias;
        this.trustStore = parent.trustStore;
        this.trustPass = parent.trustPass;
        this.externalToken = parent.externalToken;
    }

    protected void applyDefaultOptionValues() {
        if (this.clientId == null) {
            this.clientId = "admin-cli";
        }
    }

    @Override
    protected boolean nothingToDo() {
        return this.externalToken == null && this.server == null && this.realm == null && this.clientId == null && this.secret == null && this.user == null && this.password == null && this.keystore == null && this.storePass == null && this.keyPass == null && this.alias == null && this.trustStore == null && this.trustPass == null && this.config == null;
    }

    @Override
    protected void processOptions() {
        if (this.config != null && this.noconfig) {
            throw new IllegalArgumentException("Options --config and --no-config are mutually exclusive");
        }
        if (!this.noconfig) {
            FileConfigHandler.setConfigFile(this.config != null ? this.config : this.getDefaultConfigFilePath());
            ConfigUtil.setHandler(new FileConfigHandler());
        } else {
            InMemoryConfigHandler handler = new InMemoryConfigHandler();
            ConfigData data = new ConfigData();
            this.initConfigData(data);
            handler.setConfigData(data);
            ConfigUtil.setHandler(handler);
        }
    }

    protected void setupTruststore(ConfigData configData) {
        if (!configData.getServerUrl().startsWith("https:")) {
            return;
        }
        String truststore = this.trustStore;
        if (truststore == null) {
            truststore = configData.getTruststore();
        }
        if (truststore != null) {
            String pass = this.trustPass;
            if (pass == null) {
                pass = configData.getTrustpass();
            }
            if (pass == null) {
                pass = IoUtil.readSecret("Enter truststore password: ");
            }
            try {
                HttpUtil.setTruststore(new File(truststore), pass);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore: " + truststore, e);
            }
        }
        if (this.insecure) {
            HttpUtil.setSkipCertificateValidation();
        }
    }

    protected ConfigData ensureAuthInfo(ConfigData config) {
        if (this.requiresLogin()) {
            ConfigHandler old = ConfigUtil.getHandler();
            try {
                this.applyDefaultOptionValues();
                this.initConfigData(config);
                ConfigUtil.setupInMemoryHandler(config);
                BaseConfigCredentialsCmd login = new BaseConfigCredentialsCmd(this.commandState);
                login.initFromParent(this);
                login.init(config);
                login.process();
                ConfigData configData = ConfigUtil.loadConfig();
                return configData;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                ConfigUtil.setHandler(old);
            }
        }
        ConfigUtil.checkServerInfo(config, this.getCommand());
        this.applyDefaultOptionValues();
        return ConfigUtil.loadConfig();
    }

    protected boolean requiresLogin() {
        return this.externalToken == null && (this.user != null || this.password != null || this.secret != null || this.keystore != null || this.keyPass != null || this.storePass != null || this.alias != null);
    }

    protected ConfigData copyWithServerInfo(ConfigData config) {
        ConfigData result = config.deepcopy();
        if (this.server != null) {
            result.setServerUrl(this.server);
        }
        if (this.realm != null) {
            result.setRealm(this.realm);
        }
        if (this.externalToken != null) {
            result.setExternalToken(this.externalToken);
        }
        ConfigUtil.checkServerInfo(result, this.getCommand());
        return result;
    }

    private void initConfigData(ConfigData data) {
        if (this.server != null) {
            data.setServerUrl(this.server);
        }
        if (this.realm != null) {
            data.setRealm(this.realm);
        }
        if (this.trustStore != null) {
            data.setTruststore(this.trustStore);
        }
        if (this.externalToken != null) {
            data.setExternalToken(this.externalToken);
        }
        RealmConfigData rdata = data.sessionRealmConfigData();
        if (this.clientId != null) {
            rdata.setClientId(this.clientId);
        }
        if (this.secret != null) {
            rdata.setSecret(this.secret);
        }
        String grantTypeForAuthentication = this.user == null ? "client_credentials" : "password";
        rdata.setGrantTypeForAuthentication(grantTypeForAuthentication);
    }

    protected String ensureToken(ConfigData config) {
        return AuthUtil.ensureToken(config, this.getCommand());
    }

    protected void globalOptions(PrintWriter out) {
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + this.commandState.getDefaultConfigFilePath() + " by default)");
        out.println("    --no-config           Don't use config file - no authentication info is loaded or saved");
        if (this.commandState.isTokenGlobal()) {
            out.println("    --token               Token to use to invoke on Keycloak.  Other credential may be ignored if this flag is set.");
        }
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified, --truststore is used, and the KC_CLI_TRUSTSTORE_PASSWORD env property is not defined)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + this.commandState.getCommand() + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. In combination with --no-config option this allows transient");
        out.println("                          (on-the-fly) authentication to be performed which leaves no tokens in config file.");
        out.println();
    }
}

