/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.quarkus.hibernate.cache.InternalCache;
import org.infinispan.quarkus.hibernate.cache.InternalRegionImpl;
import org.jboss.logging.Logger;

final class TimestampsRegionImpl
implements TimestampsRegion {
    private static final Logger log = Logger.getLogger(TimestampsRegionImpl.class);
    private final InternalCache cache;
    private final String name;
    private final InternalRegionImpl internalRegion;
    private final RegionFactory regionFactory;

    TimestampsRegionImpl(InternalCache cache, String name, RegionFactory regionFactory) {
        this.cache = cache;
        this.name = name;
        this.regionFactory = regionFactory;
        this.internalRegion = new InternalRegionImpl((Region)this);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (this.internalRegion.checkValid()) {
            return this.cache.getOrNull(key);
        }
        return null;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        this.cache.put(key, value);
    }

    public String getName() {
        return this.name;
    }

    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }

    public void clear() {
        this.internalRegion.beginInvalidation();
        this.runInvalidation();
        this.internalRegion.endInvalidation();
    }

    private void runInvalidation() {
        log.tracef("Non-transactional, clear in one go", new Object[0]);
        this.cache.invalidateAll();
    }

    public void destroy() {
    }
}

