/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import com.apicatalog.jsonld.JsonLdEmbed;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.framing.FrameMatcher;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.framing.ValuePatternMatcher;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DefaultObject;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class Frame {
    public static final Frame EMPTY = new Frame(JsonValue.EMPTY_JSON_OBJECT);
    private final JsonObject frameObject;

    private Frame(JsonObject frameObject) {
        this.frameObject = frameObject;
    }

    public static final Frame of(JsonStructure structure) throws JsonLdError {
        JsonObject frameObject;
        if (JsonUtils.isArray((JsonValue)structure)) {
            if (structure.asJsonArray().size() != 1 || JsonUtils.isNotObject((JsonValue)structure.asJsonArray().get(0))) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_FRAME, "Frame is not JSON object nor an array containing JSON object [" + structure + "]");
            }
            frameObject = structure.asJsonArray().getJsonObject(0);
        } else if (JsonUtils.isObject((JsonValue)structure)) {
            frameObject = structure.asJsonObject();
        } else {
            throw new JsonLdError(JsonLdErrorCode.INVALID_FRAME, "Frame is not JSON object. [" + structure + "]");
        }
        if (frameObject.containsKey((Object)"@id") && !Frame.validateFrameId(frameObject)) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_FRAME, "Frame @id value is not valid [@id = " + frameObject.get((Object)"@id") + "].");
        }
        if (frameObject.containsKey((Object)"@type") && !Frame.validateFrameType(frameObject)) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_FRAME, "Frame @type value i not valid [@type = " + frameObject.get((Object)"@type") + "].");
        }
        return new Frame(frameObject);
    }

    public JsonLdEmbed getEmbed(JsonLdEmbed defaultValue) throws JsonLdError {
        if (this.frameObject.containsKey((Object)"@embed")) {
            JsonValue embed = (JsonValue)this.frameObject.get((Object)"@embed");
            if (JsonUtils.isNull(embed)) {
                return defaultValue;
            }
            if (ValueObject.isValueObject(embed)) {
                embed = ValueObject.getValue(embed).orElseThrow(() -> new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_EMBED_VALUE));
            }
            if (JsonUtils.isString(embed)) {
                String stringValue = ((JsonString)embed).getString();
                if (Keywords.noneMatch(stringValue, "@always", "@once", "@never")) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_EMBED_VALUE, "The value for @embed is not one recognized for the object embed flag [@embed = " + stringValue + "].");
                }
                return JsonLdEmbed.valueOf(stringValue.substring(1).toUpperCase());
            }
            if (JsonUtils.isFalse(embed)) {
                return JsonLdEmbed.NEVER;
            }
            if (JsonUtils.isTrue(embed)) {
                return JsonLdEmbed.ONCE;
            }
            throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_EMBED_VALUE, "The value for @embed is not one recognized for the object embed flag [@embed = " + embed + "].");
        }
        return defaultValue;
    }

    public boolean getExplicit(boolean defaultValue) throws JsonLdError {
        return Frame.getBoolean(this.frameObject, "@explicit", defaultValue);
    }

    public boolean getRequireAll(boolean defaultValue) throws JsonLdError {
        return Frame.getBoolean(this.frameObject, "@requireAll", defaultValue);
    }

    public static final boolean getBoolean(JsonObject frame, String key, boolean defaultValue) throws JsonLdError {
        if (frame.containsKey((Object)key)) {
            JsonValue value = (JsonValue)frame.get((Object)key);
            if (JsonUtils.isNull(value)) {
                return defaultValue;
            }
            if (ValueObject.isValueObject(value)) {
                value = ValueObject.getValue(value).orElseThrow(() -> new JsonLdError(JsonLdErrorCode.INVALID_FRAME));
            }
            if (JsonUtils.isString(value)) {
                if ("true".equalsIgnoreCase(((JsonString)value).getString())) {
                    return true;
                }
                if ("false".equalsIgnoreCase(((JsonString)value).getString())) {
                    return false;
                }
            }
            if (JsonUtils.isNotBoolean(value)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_FRAME);
            }
            return JsonUtils.isTrue(value);
        }
        return defaultValue;
    }

    private static final boolean validateFrameId(JsonObject frame) {
        JsonValue id = (JsonValue)frame.get((Object)"@id");
        if (JsonUtils.isNonEmptyArray(id)) {
            JsonArray idArray = id.asJsonArray();
            return idArray.size() == 1 && JsonUtils.isEmptyObject((JsonValue)idArray.get(0)) || idArray.stream().noneMatch(item -> JsonUtils.isNotString(item) || UriUtils.isNotAbsoluteUri(((JsonString)item).getString(), true));
        }
        return JsonUtils.isString(id) && UriUtils.isAbsoluteUri(((JsonString)id).getString(), true);
    }

    private static final boolean validateFrameType(JsonObject frame) {
        JsonValue type = (JsonValue)frame.get((Object)"@type");
        if (JsonUtils.isNonEmptyArray(type)) {
            JsonArray typeArray = type.asJsonArray();
            return typeArray.size() == 1 && (JsonUtils.isEmptyObject((JsonValue)typeArray.get(0)) || JsonUtils.containsKey((JsonValue)typeArray.get(0), "@default")) || typeArray.stream().noneMatch(item -> JsonUtils.isNotString(item) || UriUtils.isNotAbsoluteUri(((JsonString)item).getString(), true));
        }
        return JsonUtils.isEmptyArray(type) || JsonUtils.isEmptyObject(type) || JsonUtils.isString(type) && UriUtils.isAbsoluteUri(((JsonString)type).getString(), true);
    }

    public Set<String> keys() {
        return this.frameObject.keySet();
    }

    public JsonValue get(String property) {
        return (JsonValue)this.frameObject.get((Object)property);
    }

    public boolean contains(String property) {
        return this.frameObject.containsKey((Object)property);
    }

    public boolean containsOnly(String property) {
        return this.frameObject.containsKey((Object)property) && ValuePatternMatcher.isWildcard((JsonValue)this.frameObject, property);
    }

    public boolean isWildCard() {
        return ValuePatternMatcher.isWildcard((JsonValue)this.frameObject, new String[0]);
    }

    public boolean isWildCard(String property) {
        return this.frameObject.containsKey((Object)property) && ValuePatternMatcher.isWildcard((JsonValue)this.frameObject.get((Object)property), new String[0]);
    }

    public boolean isNone(String property) {
        return this.frameObject.containsKey((Object)property) && ValuePatternMatcher.isNone((JsonValue)this.frameObject.get((Object)property));
    }

    public Collection<JsonValue> getCollection(String property) {
        return this.frameObject.containsKey((Object)property) ? JsonUtils.toJsonArray((JsonValue)this.frameObject.get((Object)property)) : JsonValue.EMPTY_JSON_ARRAY;
    }

    public String toString() {
        return this.frameObject.toString();
    }

    public boolean isValuePattern() {
        return ValueObject.isValueObject((JsonValue)this.frameObject);
    }

    public boolean matchValue(JsonValue value) {
        return JsonUtils.isObject(value) && ValuePatternMatcher.with(this.frameObject, value.asJsonObject()).match();
    }

    public boolean isDefaultObject(String property) {
        return DefaultObject.isDefaultObject((JsonValue)this.frameObject.get((Object)property)) || JsonUtils.isArray((JsonValue)this.frameObject.get((Object)property)) && ((JsonValue)this.frameObject.get((Object)property)).asJsonArray().size() == 1 && DefaultObject.isDefaultObject((JsonValue)((JsonValue)this.frameObject.get((Object)property)).asJsonArray().get(0));
    }

    public boolean isNodePattern() {
        return NodeObject.isNodeObject((JsonValue)this.frameObject);
    }

    public boolean isNodeReference() {
        return NodeObject.isNodeReference((JsonValue)this.frameObject);
    }

    public boolean matchNode(FramingState state, JsonValue value, boolean requireAll) throws JsonLdError {
        if (JsonUtils.isNotObject(value) || !value.asJsonObject().containsKey((Object)"@id")) {
            return false;
        }
        Optional<Map> valueObject = state.getGraphMap().get(state.getGraphName()).map(graph -> (Map)graph.get(value.asJsonObject().getString("@id")));
        return valueObject.isPresent() && FrameMatcher.with(state, this, requireAll).match(valueObject.get());
    }

    public boolean isListObject() {
        return ListObject.isListObject((JsonValue)this.frameObject);
    }
}

