/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.Average;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class AverageMinMax
extends Average {
    protected long min = Long.MAX_VALUE;
    protected long max = 0L;
    protected List<Long> values;

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public boolean usePercentiles() {
        return this.values != null;
    }

    public AverageMinMax usePercentiles(int capacity) {
        this.values = capacity > 0 ? new ArrayList(capacity) : null;
        return this;
    }

    @Override
    public <T extends Average> T add(long num) {
        super.add(num);
        this.min = Math.min(this.min, num);
        this.max = Math.max(this.max, num);
        if (this.values != null) {
            this.values.add(num);
        }
        return (T)this;
    }

    @Override
    public <T extends Average> T merge(T other) {
        if (other.count() == 0L) {
            return (T)this;
        }
        super.merge(other);
        if (other instanceof AverageMinMax) {
            AverageMinMax o = (AverageMinMax)other;
            this.min = Math.min(this.min, o.min());
            this.max = Math.max(this.max, o.max());
            if (this.values != null) {
                this.values.addAll(o.values);
            }
        }
        return (T)this;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.values != null) {
            this.values.clear();
        }
        this.min = Long.MAX_VALUE;
        this.max = 0L;
    }

    public String percentiles() {
        if (this.values == null) {
            return "n/a";
        }
        Collections.sort(this.values);
        double stddev = this.stddev();
        return String.format("stddev: %.2f, 50: %d, 90: %d, 99: %d, 99.9: %d, 99.99: %d, 99.999: %d, 100: %d\n", stddev, this.p(50.0), this.p(90.0), this.p(99.0), this.p(99.9), this.p(99.99), this.p(99.999), this.p(100.0));
    }

    @Override
    public String toString() {
        return this.count == 0L ? "n/a" : (this.unit != null ? this.toString(this.unit) : String.format("min/avg/max=%,d/%,.2f/%,d%s", this.min, this.getAverage(), this.max, this.unit == null ? "" : " " + Util.suffix(this.unit)));
    }

    @Override
    public String toString(TimeUnit u) {
        if (this.count == 0L) {
            return "n/a";
        }
        return String.format("%s/%s/%s", Util.printTime(this.min, u), Util.printTime(this.getAverage(), u), Util.printTime(this.max, u));
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeLongCompressed(this.min, out);
        Bits.writeLongCompressed(this.max, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.min = Bits.readLongCompressed(in);
        this.max = Bits.readLongCompressed(in);
    }

    protected long p(double percentile) {
        if (this.values == null) {
            return -1L;
        }
        int size = this.values.size();
        int index = (int)((double)size * (percentile / 100.0));
        return this.values.get(index - 1);
    }

    protected double stddev() {
        if (this.values == null) {
            return -1.0;
        }
        double av = this.average();
        int size = this.values.size();
        double variance = this.values.stream().map(v -> ((double)v.longValue() - av) * ((double)v.longValue() - av)).reduce(0.0, Double::sum) / (double)size;
        return Math.sqrt(variance);
    }
}

