/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.management.MBeanAttributeInfo;
import org.jgroups.JChannel;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ExtractMetrics {
    protected JChannel ch;

    public static Map<String, Map<String, Entry>> extract(JChannel ch) {
        HashMap<String, Map<String, Entry>> map = new HashMap<String, Map<String, Entry>>();
        for (Protocol p : ch.stack().getProtocols()) {
            map.put(p.getName(), ExtractMetrics.extract(p));
        }
        return map;
    }

    public static Map<String, Entry> extract(Protocol p) {
        HashMap<String, Entry> map = new HashMap<String, Entry>();
        ResourceDMBean dm = new ResourceDMBean(p);
        dm.forAllAttributes((k, v) -> {
            MBeanAttributeInfo info = v.info();
            String descr = info != null ? info.getDescription() : "n/a";
            Supplier<Object> getter = () -> {
                try {
                    return v.getter() != null ? v.getter().invoke(null) : null;
                }
                catch (Exception e) {
                    System.err.printf("failed getting value for %s\n", k);
                    return null;
                }
            };
            map.put((String)k, new Entry(descr, getter));
        });
        return map;
    }

    protected void start() throws Exception {
        this.ch = new JChannel().connect("bla").name("X");
        Map<String, Map<String, Entry>> map = ExtractMetrics.extract(this.ch);
        for (Map.Entry<String, Map<String, Entry>> e : map.entrySet()) {
            System.out.printf("\n%s:\n---------------\n", e.getKey());
            for (Map.Entry<String, Entry> e2 : e.getValue().entrySet()) {
                System.out.printf("  %s: %s\n", e2.getKey(), e2.getValue());
            }
        }
        Util.close((Closeable)this.ch);
    }

    public static void main(String[] args) throws Throwable {
        new ExtractMetrics().start();
    }

    public static class Entry {
        protected final String description;
        protected final Supplier<Object> method;

        protected Entry(String description, Supplier<Object> method) {
            this.description = description;
            this.method = method;
        }

        public String getDescription() {
            return this.description;
        }

        public Supplier<Object> getMethod() {
            return this.method;
        }

        public String toString() {
            return String.format("  %s [%s]", this.method.get(), this.description);
        }
    }
}

